/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.core.base.BaseDateTime;
import adams.data.mapobject.TimestampSupporter;
import adams.flow.sink.openstreetmapviewer.AbstractMapObjectPruner;
import java.util.Date;
import org.openstreetmap.gui.jmapviewer.JMapViewerTree;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public class TimestampPruner
extends AbstractMapObjectPruner {
    private static final long serialVersionUID = -135743438219473331L;
    protected BaseDateTime m_CutOff;

    public String globalInfo() {
        return "Removes map objects that are older than the specified cut-off date.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cut-off", "cutOff", (Object)new BaseDateTime("-INF"));
    }

    public void setCutOff(BaseDateTime value) {
        this.m_CutOff = value;
        this.reset();
    }

    public BaseDateTime getCutOff() {
        return this.m_CutOff;
    }

    public String cutOffTipText() {
        return "The cut-off date, ie any map object older than this gets removed.";
    }

    @Override
    protected void doPrune(JMapViewerTree tree) {
        MapObject mapobject;
        Date cutoff = this.m_CutOff.dateValue();
        int i = 0;
        int pruned = 0;
        while (i < tree.getViewer().getMapMarkerList().size()) {
            mapobject = (MapObject)tree.getViewer().getMapMarkerList().get(i);
            if (mapobject instanceof TimestampSupporter && ((TimestampSupporter)mapobject).getTimestamp().compareTo(cutoff) < 0) {
                tree.getViewer().getMapMarkerList().remove(i);
                ++pruned;
                continue;
            }
            ++i;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Markers pruned: " + pruned);
        }
        i = 0;
        pruned = 0;
        while (i < tree.getViewer().getMapRectangleList().size()) {
            mapobject = (MapObject)tree.getViewer().getMapRectangleList().get(i);
            if (mapobject instanceof TimestampSupporter && ((TimestampSupporter)mapobject).getTimestamp().compareTo(cutoff) < 0) {
                tree.getViewer().getMapRectangleList().remove(i);
                ++pruned;
                continue;
            }
            ++i;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Rectangles pruned: " + pruned);
        }
        i = 0;
        pruned = 0;
        while (i < tree.getViewer().getMapPolygonList().size()) {
            mapobject = (MapObject)tree.getViewer().getMapPolygonList().get(i);
            if (mapobject instanceof TimestampSupporter && ((TimestampSupporter)mapobject).getTimestamp().compareTo(cutoff) < 0) {
                tree.getViewer().getMapPolygonList().remove(i);
                ++pruned;
                continue;
            }
            ++i;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Polygons pruned: " + pruned);
        }
    }
}

