/*
 * Decompiled with CFR 0.152.
 */
package mulan.examples;

import java.util.Arrays;
import mulan.data.MultiLabelInstances;
import mulan.dimensionalityReduction.BinaryRelevanceAttributeEvaluator;
import mulan.dimensionalityReduction.Ranker;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.GainRatioAttributeEval;
import weka.core.Instances;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class DimensionalityReductionTest {
    public static void main(String[] args) throws Exception {
        String path = Utils.getOption((String)"path", (String[])args);
        String filestem = Utils.getOption((String)"filestem", (String[])args);
        MultiLabelInstances mlData = new MultiLabelInstances(path + filestem + ".arff", path + filestem + ".xml");
        GainRatioAttributeEval ase = new GainRatioAttributeEval();
        BinaryRelevanceAttributeEvaluator ae = new BinaryRelevanceAttributeEvaluator((ASEvaluation)ase, mlData, "max", "dl", "eval");
        Ranker r = new Ranker();
        int[] result = r.search(ae, mlData);
        System.out.println(Arrays.toString(result));
        int NUM_TO_KEEP = 10;
        int[] toKeep = new int[10 + mlData.getNumLabels()];
        System.arraycopy(result, 0, toKeep, 0, 10);
        int[] labelIndices = mlData.getLabelIndices();
        System.arraycopy(labelIndices, 0, toKeep, 10, mlData.getNumLabels());
        Remove filterRemove = new Remove();
        filterRemove.setAttributeIndicesArray(toKeep);
        filterRemove.setInvertSelection(true);
        filterRemove.setInputFormat(mlData.getDataSet());
        Instances filtered = Filter.useFilter((Instances)mlData.getDataSet(), (Filter)filterRemove);
        MultiLabelInstances mlFiltered = new MultiLabelInstances(filtered, mlData.getLabelsMetaData());
    }
}

