/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tree;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tree.CommonNode;
import java.text.Format;

public class PropertyNode
extends CommonNode {
    private Format propertyFormat;
    private String propertyLabel;
    private String propertyName;
    private final boolean reusable;

    public PropertyNode(CommonNode commonNode, Object object, String string, String string2, boolean bl) {
        super(commonNode, object);
        this.propertyLabel = string;
        this.propertyName = string2;
        this.reusable = bl;
    }

    @Override
    public String getIconName() {
        return "icons/treenode_property";
    }

    @Override
    public String getLabel() {
        String string;
        Object object = this.getPropertyValue();
        if (this.propertyFormat != null) {
            try {
                string = this.propertyFormat.format(object);
            }
            catch (Exception exception) {
                string = StringTools.safeString(object);
            }
        } else {
            string = object instanceof IPresentationSupport ? ((IPresentationSupport)object).getLabel() : StringTools.safeString(object);
        }
        return String.valueOf(this.getPropertyLabel()) + "=" + string;
    }

    public Format getPropertyFormat() {
        return this.propertyFormat;
    }

    public String getPropertyLabel() {
        return this.propertyLabel;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        try {
            return ObjectTools.get(this.getObject(), this.getPropertyName());
        }
        catch (FieldException fieldException) {
            return "<not available>";
        }
    }

    @Override
    protected boolean isReusable() {
        return this.reusable;
    }

    @Override
    protected void onAttributeChanged(AttributeChangedEvent attributeChangedEvent) {
        String string;
        String string2 = string = attributeChangedEvent.getAttribute() instanceof String ? (String)attributeChangedEvent.getAttribute() : "?";
        if (this.propertyName.startsWith(string)) {
            super.onAttributeChanged(attributeChangedEvent);
        }
    }

    public void setPropertyFormat(Format format) {
        this.propertyFormat = format;
    }
}

