/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.core.scripting.RScript;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.Rserve;
import org.rosuda.REngine.Rserve.RConnection;

public class RStandalone
extends AbstractStandalone {
    private static final long serialVersionUID = 7114485978382420994L;
    protected RScript m_Script;
    protected RConnection m_RConn;
    protected Rserve m_Rserve;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "script", (Object)new RScript());
    }

    protected void reset() {
        super.reset();
        this.m_RConn = null;
    }

    public RScript getScript() {
        return this.m_Script;
    }

    public void setScript(RScript script) {
        this.m_Script = script;
        this.reset();
    }

    public String scriptTipText() {
        return "Script to pass into R.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"script", (Object)Utils.shorten((String)(this.m_Script.stringValue().length() == 0 ? "-none-" : this.m_Script.stringValue()), (int)40), (String)"script: ");
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Rserve = (Rserve)ActorUtils.findClosestType((AbstractActor)this, Rserve.class, (boolean)true);
            if (this.m_Rserve == null) {
                result = "Failed to find " + Rserve.class.getName() + " standalone with Rserve configuration!";
            }
        }
        return result;
    }

    protected String doExecute() {
        String[] lines;
        if (this.m_RConn == null) {
            this.m_RConn = this.m_Rserve.newConnection();
            if (this.m_RConn == null) {
                return "Could not connect to Rserve!";
            }
        }
        String expr = this.getVariables().expand(this.m_Script.getValue());
        expr = Placeholders.expandStr((String)expr);
        for (String line : lines = expr.split("\r?\n")) {
            try {
                this.m_RConn.eval(line);
            }
            catch (Exception ex) {
                return this.handleException("Error occurred evaluating: " + line, ex);
            }
        }
        return null;
    }

    public String globalInfo() {
        return "Carries out an R function on the input script.";
    }

    public void wrapUp() {
        if (this.m_Rserve != null) {
            this.m_Rserve.closeConnection(this.m_RConn);
            this.m_RConn = null;
            this.m_Rserve = null;
        }
        super.wrapUp();
    }
}

