/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.webservice.WebServiceClientConsumer;
import java.net.URL;
import java.util.logging.Level;

public abstract class AbstractWebServiceClientSink<I>
extends AbstractOptionHandler
implements WebServiceClientConsumer<I>,
QuickInfoSupporter {
    private static final long serialVersionUID = 3420305488797791952L;
    protected AbstractActor m_Owner;
    protected int m_ConnectionTimeout;
    protected int m_ReceiveTimeout;
    protected boolean m_UseAlternativeURL;
    protected String m_AlternativeURL;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("connection-timeout", "connectionTimeout", (Object)300000, (Number)0, null);
        this.m_OptionManager.add("receive-timeout", "receiveTimeout", (Object)300000, (Number)0, null);
        this.m_OptionManager.add("use-alternative-url", "useAlternativeURL", (Object)false);
        this.m_OptionManager.add("alternative-url", "alternativeURL", (Object)this.getDefaultAlternativeURL());
    }

    @Override
    public void setConnectionTimeout(int value) {
        this.m_ConnectionTimeout = value;
        this.reset();
    }

    @Override
    public int getConnectionTimeout() {
        return this.m_ConnectionTimeout;
    }

    public String connectionTimeoutTipText() {
        return "The connection timeout in msec, 0 is infinite.";
    }

    @Override
    public void setReceiveTimeout(int value) {
        this.m_ReceiveTimeout = value;
        this.reset();
    }

    @Override
    public int getReceiveTimeout() {
        return this.m_ReceiveTimeout;
    }

    public String receiveTimeoutTipText() {
        return "The timeout for receiving in msec, 0 is infinite.";
    }

    public void setUseAlternativeURL(boolean value) {
        this.m_UseAlternativeURL = value;
        this.reset();
    }

    public boolean getUseAlternativeURL() {
        return this.m_UseAlternativeURL;
    }

    public String useAlternativeURLTipText() {
        return "If enabled, the specified alternative URL is used.";
    }

    public String getDefaultAlternativeURL() {
        return "http://localhost:8080/";
    }

    public void setAlternativeURL(String value) {
        try {
            new URL(value);
            this.m_AlternativeURL = value;
            this.reset();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Invalid URL: " + value, e);
        }
    }

    public String getAlternativeURL() {
        return this.m_AlternativeURL;
    }

    public String alternativeURLTipText() {
        return "The URL of the service.";
    }

    public String getQuickInfo() {
        String result = null;
        if (this.m_UseAlternativeURL || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"useAlternativeURL")) {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"alternativeURL", (Object)this.m_AlternativeURL);
        }
        return result;
    }

    @Override
    public void setOwner(AbstractActor value) {
        this.m_Owner = value;
    }

    @Override
    public AbstractActor getOwner() {
        return this.m_Owner;
    }

    protected abstract URL getWsdlLocation();

    protected void preQuery() throws Exception {
        if (this.m_Owner == null) {
            throw new IllegalStateException("No owning actor set!");
        }
    }

    protected abstract void doQuery() throws Exception;

    protected void postQuery() throws Exception {
    }

    @Override
    public void query() throws Exception {
        this.preQuery();
        this.doQuery();
        this.postQuery();
    }

    public void cleanUp() {
    }
}

