/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.se;

import georegression.fitting.MotionTransformPoint;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.UtilPoint3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class MotionSe3PointSVD_F64
implements MotionTransformPoint<Se3_F64, Point3D_F64> {
    private Se3_F64 motion = new Se3_F64();
    SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)false);

    @Override
    public Se3_F64 getMotion() {
        return this.motion;
    }

    @Override
    public boolean process(List<Point3D_F64> fromPts, List<Point3D_F64> toPts) {
        if (fromPts.size() != toPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        Point3D_F64 meanFrom = UtilPoint3D_F64.mean(fromPts);
        Point3D_F64 meanTo = UtilPoint3D_F64.mean(toPts);
        int N = fromPts.size();
        double s11 = 0.0;
        double s12 = 0.0;
        double s13 = 0.0;
        double s21 = 0.0;
        double s22 = 0.0;
        double s23 = 0.0;
        double s31 = 0.0;
        double s32 = 0.0;
        double s33 = 0.0;
        for (int i = 0; i < N; ++i) {
            Point3D_F64 f = fromPts.get(i);
            Point3D_F64 t = toPts.get(i);
            double dfx = f.x - meanFrom.x;
            double dfy = f.y - meanFrom.y;
            double dfz = f.z - meanFrom.z;
            double dtx = t.x - meanTo.x;
            double dty = t.y - meanTo.y;
            double dtz = t.z - meanTo.z;
            s11 += dtx * dfx;
            s12 += dtx * dfy;
            s13 += dtx * dfz;
            s21 += dty * dfx;
            s22 += dty * dfy;
            s23 += dty * dfz;
            s31 += dtz * dfx;
            s32 += dtz * dfy;
            s33 += dtz * dfz;
        }
        DenseMatrix64F Sigma = new DenseMatrix64F(3, 3, true, new double[]{s11, s12, s13, s21, s22, s23, s31, s32, s33});
        if (!this.svd.decompose((Matrix64F)Sigma)) {
            throw new RuntimeException("SVD failed!?");
        }
        DenseMatrix64F U = (DenseMatrix64F)this.svd.getU(null, false);
        DenseMatrix64F V = (DenseMatrix64F)this.svd.getV(null, false);
        SingularOps.descendingOrder((DenseMatrix64F)U, (boolean)false, (double[])this.svd.getSingularValues(), (int)3, (DenseMatrix64F)V, (boolean)false);
        if (CommonOps.det((DenseMatrix64F)U) < 0.0 ^ CommonOps.det((DenseMatrix64F)V) < 0.0) {
            V.data[2] = -V.data[2];
            V.data[5] = -V.data[5];
            V.data[8] = -V.data[8];
        }
        CommonOps.multTransB((RowD1Matrix64F)U, (RowD1Matrix64F)V, (RowD1Matrix64F)this.motion.getR());
        Point3D_F64 temp = new Point3D_F64();
        GeometryMath_F64.mult(this.motion.getR(), meanFrom, temp);
        this.motion.getT().set(meanTo.x - temp.x, meanTo.y - temp.y, meanTo.z - temp.z);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

