/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.metric.Distance2D_F64;
import georegression.metric.UtilAngle;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LinePolar2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;

public class UtilLine2D_F64 {
    public static LineParametric2D_F64 convert(LinePolar2D_F64 src, LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        double c = Math.cos(src.angle);
        double s = Math.sin(src.angle);
        ret.p.set(c * src.distance, s * src.distance);
        ret.slope.set(-s, c);
        return ret;
    }

    public static LineParametric2D_F64 convert(LineSegment2D_F64 src, LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        ret.p.set(src.a);
        ret.slope.set(src.slopeX(), src.slopeY());
        return ret;
    }

    public static LinePolar2D_F64 convert(LineParametric2D_F64 src, LinePolar2D_F64 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F64();
        }
        ret.angle = UtilAngle.atanSafe(-src.getSlopeX(), src.getSlopeY());
        ret.distance = Distance2D_F64.distance(src, new Point2D_F64());
        if (src.getSlopeY() < 0.0) {
            ret.distance = -ret.distance;
        }
        return ret;
    }

    public static LineGeneral2D_F64 convert(LineParametric2D_F64 src, LineGeneral2D_F64 ret) {
        if (ret == null) {
            ret = new LineGeneral2D_F64();
        }
        double x1 = src.p.x + src.slope.x;
        double y1 = src.p.y + src.slope.y;
        ret.A = src.p.y - y1;
        ret.B = x1 - src.p.x;
        ret.C = src.p.x * y1 - x1 * src.p.y;
        return ret;
    }

    public static LineParametric2D_F64 convert(LineGeneral2D_F64 src, LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        ret.slope.x = src.B;
        ret.slope.y = -src.A;
        if (Math.abs(src.B) > Math.abs(src.A)) {
            ret.p.y = -src.C / src.B;
            ret.p.x = 0.0;
        } else {
            ret.p.x = -src.C / src.A;
            ret.p.y = 0.0;
        }
        return ret;
    }
}

