/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.metric.MiscOps;
import georegression.struct.line.LineParametric3D_F64;
import georegression.struct.plane.PlaneGeneral3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;

public class ClosestPoint3D_F64 {
    public static Point3D_F64 closestPoint(LineParametric3D_F64 l0, LineParametric3D_F64 l1, Point3D_F64 ret) {
        if (ret == null) {
            ret = new Point3D_F64();
        }
        ret.x = l0.p.x - l1.p.x;
        ret.y = l0.p.y - l1.p.y;
        ret.z = l0.p.z - l1.p.z;
        double dv01v1 = MiscOps.dot(ret, l1.slope);
        double dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        double dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        double t0 = dv01v1 * dv1v0 - MiscOps.dot(ret, l0.slope) * dv1v1;
        double bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        if (bottom == 0.0) {
            return null;
        }
        double t1 = (dv01v1 + (t0 /= bottom) * dv1v0) / dv1v1;
        ret.x = 0.5 * (l0.p.x + t0 * l0.slope.x + (l1.p.x + t1 * l1.slope.x));
        ret.y = 0.5 * (l0.p.y + t0 * l0.slope.y + (l1.p.y + t1 * l1.slope.y));
        ret.z = 0.5 * (l0.p.z + t0 * l0.slope.z + (l1.p.z + t1 * l1.slope.z));
        return ret;
    }

    public static boolean closestPoints(LineParametric3D_F64 l0, LineParametric3D_F64 l1, double[] param) {
        double dX = l0.p.x - l1.p.x;
        double dY = l0.p.y - l1.p.y;
        double dZ = l0.p.z - l1.p.z;
        double dv01v1 = MiscOps.dot(dX, dY, dZ, l1.slope);
        double dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        double dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        double t0 = dv01v1 * dv1v0 - MiscOps.dot(dX, dY, dZ, l0.slope) * dv1v1;
        double bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        if (bottom == 0.0) {
            return false;
        }
        double t1 = (dv01v1 + (t0 /= bottom) * dv1v0) / dv1v1;
        param[0] = t0;
        param[1] = t1;
        return true;
    }

    public static Point3D_F64 closestPoint(LineParametric3D_F64 line, Point3D_F64 pt, Point3D_F64 ret) {
        if (ret == null) {
            ret = new Point3D_F64();
        }
        Vector3D_F64 ab = new Vector3D_F64(line.p, pt);
        double n = line.slope.norm();
        double d = line.slope.dot(ab) / n;
        ret.x = line.p.x + d * line.slope.x / n;
        ret.y = line.p.y + d * line.slope.y / n;
        ret.z = line.p.z + d * line.slope.z / n;
        return ret;
    }

    public static Point3D_F64 closestPoint(PlaneGeneral3D_F64 plane, Point3D_F64 point, Point3D_F64 found) {
        if (found == null) {
            found = new Point3D_F64();
        }
        double top = plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
        double n2 = plane.A * plane.A + plane.B * plane.B + plane.C * plane.C;
        found.x = point.x - plane.A * top / n2;
        found.y = point.y - plane.B * top / n2;
        found.z = point.z - plane.C * top / n2;
        return found;
    }
}

