/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Rectangle2D_F64;

public class Intersection2D_F64 {
    public static boolean containConvex(Polygon2D_F64 polygon, Point2D_F64 pt) {
        int N = polygon.vertexes.length;
        boolean c = false;
        int i = 0;
        int j = N - 1;
        while (i < N) {
            Point2D_F64 a = polygon.vertexes[i];
            Point2D_F64 b = polygon.vertexes[j];
            if (a.y > pt.y != b.y > pt.y && pt.x < (b.x - a.x) * (pt.y - a.y) / (b.y - a.y) + a.x) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    public static boolean containConcave(Polygon2D_F64 polygon, Point2D_F64 pt) {
        int N = polygon.vertexes.length;
        int left = 0;
        int right = 0;
        for (int i = 0; i < N - 1; ++i) {
            double x;
            Point2D_F64 a = polygon.vertexes[i];
            Point2D_F64 b = polygon.vertexes[i + 1];
            if (!(pt.y >= a.y && pt.y < b.y) && (!(pt.y >= b.y) || !(pt.y < a.y))) continue;
            double d = x = b.y == a.y ? pt.x : (pt.y - a.y) * (b.x - a.x) / (b.y - a.y) + a.x;
            if (x <= pt.x) {
                ++left;
                continue;
            }
            if (!(x > pt.x)) continue;
            ++right;
        }
        Point2D_F64 a = polygon.vertexes[N - 1];
        Point2D_F64 b = polygon.vertexes[0];
        if (pt.y >= a.y && pt.y < b.y || pt.y >= b.y && pt.y < a.y) {
            double x;
            double d = x = b.y == a.y ? pt.x : (pt.y - pt.y) * (b.x - a.x) / (b.y - a.y) + a.x;
            if (x <= pt.x) {
                ++left;
            } else if (x > pt.x) {
                ++right;
            }
        }
        return left % 2 == 1 && right % 2 == 1;
    }

    public static Point2D_F64 intersection(LineParametric2D_F64 a, LineParametric2D_F64 b, Point2D_F64 ret) {
        double t_b = a.getSlopeX() * (b.getY() - a.getY()) - a.getSlopeY() * (b.getX() - a.getX());
        double bottom = a.getSlopeY() * b.getSlopeX() - b.getSlopeY() * a.getSlopeX();
        if (bottom == 0.0) {
            return null;
        }
        double x = b.getSlopeX() * (t_b /= bottom) + b.getX();
        double y = b.getSlopeY() * t_b + b.getY();
        if (ret == null) {
            ret = new Point2D_F64();
        }
        ret.set(x, y);
        return ret;
    }

    public static double intersection(LineParametric2D_F64 a, LineParametric2D_F64 b) {
        double t_a = b.getSlopeX() * (a.getY() - b.getY()) - b.getSlopeY() * (a.getX() - b.getX());
        double bottom = b.getSlopeY() * a.getSlopeX() - a.getSlopeY() * b.getSlopeX();
        if (bottom == 0.0) {
            return Double.NaN;
        }
        return t_a / bottom;
    }

    public static Point2D_F64 intersection(LineSegment2D_F64 l_0, LineSegment2D_F64 l_1, Point2D_F64 ret) {
        double a0 = l_0.b.x - l_0.a.x;
        double b0 = l_0.b.y - l_0.a.y;
        double a1 = l_1.b.x - l_1.a.x;
        double b1 = l_1.b.y - l_1.a.y;
        double top = b0 * (l_1.a.x - l_0.a.x) + a0 * (l_0.a.y - l_1.a.y);
        double bottom = a0 * b1 - b0 * a1;
        if (bottom == 0.0) {
            return null;
        }
        double t_1 = top / bottom;
        if (t_1 < 0.0 || t_1 > 1.0) {
            return null;
        }
        top = b1 * (l_0.a.x - l_1.a.x) + a1 * (l_1.a.y - l_0.a.y);
        bottom = a1 * b0 - b1 * a0;
        double t_0 = top / bottom;
        if (t_0 < 0.0 || t_0 > 1.0) {
            return null;
        }
        if (ret == null) {
            ret = new Point2D_F64();
        }
        ret.set(l_1.a.x + a1 * t_1, l_1.a.y + b1 * t_1);
        return ret;
    }

    public static Point3D_F64 intersection(LineGeneral2D_F64 a, LineGeneral2D_F64 b, Point3D_F64 ret) {
        if (ret == null) {
            ret = new Point3D_F64();
        }
        ret.x = a.B * b.C - a.C * b.B;
        ret.y = a.C * b.A - a.A * b.C;
        ret.z = a.A * b.B - a.B * b.A;
        return ret;
    }

    public static double intersection(LineParametric2D_F64 target, LineSegment2D_F64 l) {
        double a1 = l.b.x - l.a.x;
        double b1 = l.b.y - l.a.y;
        double top = target.slope.y * (l.a.x - target.p.x) + target.slope.x * (target.p.y - l.a.y);
        double bottom = target.slope.x * b1 - target.slope.y * a1;
        if (bottom == 0.0) {
            return Double.NaN;
        }
        double t_1 = top / bottom;
        if (t_1 < 0.0 || t_1 > 1.0) {
            return Double.NaN;
        }
        top = b1 * (target.p.x - l.a.x) + a1 * (l.a.y - target.p.y);
        bottom = a1 * target.slope.y - b1 * target.slope.x;
        return top / bottom;
    }

    public static boolean contains(Rectangle2D_F64 a, double x, double y) {
        if (a.getX() <= x && a.getX() + a.getWidth() > x) {
            return a.getY() <= y && a.getY() + a.getHeight() > y;
        }
        return false;
    }

    public static Rectangle2D_F64 intersection(Rectangle2D_F64 a, Rectangle2D_F64 b) {
        double h;
        double tl_y;
        double w;
        double tl_x;
        if (a.getX() >= b.getX()) {
            if (a.getX() >= b.getX() + b.getWidth()) {
                return null;
            }
            tl_x = a.getX();
            w = b.getX() + b.getWidth() - a.getX();
        } else {
            if (a.getX() + a.getWidth() <= b.getX()) {
                return null;
            }
            tl_x = b.getX();
            w = a.getX() + a.getWidth() - b.getX();
        }
        if (a.getY() >= b.getY()) {
            if (a.getY() >= b.getY() + b.getHeight()) {
                return null;
            }
            tl_y = a.getY();
            h = b.getY() + b.getHeight() - a.getY();
        } else {
            if (a.getY() + a.getHeight() <= b.getY()) {
                return null;
            }
            tl_y = b.getY();
            h = a.getY() + a.getHeight() - b.getY();
        }
        return new Rectangle2D_F64(tl_x, tl_y, w, h);
    }
}

