/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class SePointOps_F64 {
    public static Point2D_F64 transform(Se2_F64 se, Point2D_F64 orig, Point2D_F64 result) {
        if (result == null) {
            result = new Point2D_F64();
        }
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        double x = orig.x;
        double y = orig.y;
        result.x = se.getX() + x * c - y * s;
        result.y = se.getY() + x * s + y * c;
        return result;
    }

    public static Point2D_F64 transform(Se2_F64 se, double x, double y, Point2D_F64 result) {
        if (result == null) {
            result = new Point2D_F64();
        }
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        result.x = se.getX() + x * c - y * s;
        result.y = se.getY() + x * s + y * c;
        return result;
    }

    public static Point2D_F64 transformReverse(Se2_F64 se, Point2D_F64 orig, Point2D_F64 result) {
        if (result == null) {
            result = new Point2D_F64();
        }
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        double x = orig.x - se.getX();
        double y = orig.y - se.getY();
        result.x = x * c + y * s;
        result.y = -x * s + y * c;
        return result;
    }

    public static void transform(Se2_F64 se, Point2D_F64[] points, int length) {
        double tranX = se.getX();
        double tranY = se.getY();
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        for (int i = 0; i < length; ++i) {
            Point2D_F64 pt = points[i];
            double x = pt.x;
            double y = pt.y;
            pt.x = tranX + x * c - y * s;
            pt.y = tranY + x * s + y * c;
        }
    }

    public static void transform(Se2_F64 se, List<Point2D_F64> points) {
        double tranX = se.getX();
        double tranY = se.getY();
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        for (Point2D_F64 pt : points) {
            double x = pt.x;
            double y = pt.y;
            pt.x = tranX + x * c - y * s;
            pt.y = tranY + x * s + y * c;
        }
    }

    public static Point3D_F64 transform(Se3_F64 se, Point3D_F64 origPt, Point3D_F64 tranPt) {
        if (tranPt == null) {
            tranPt = new Point3D_F64();
        }
        DenseMatrix64F R = se.getR();
        Vector3D_F64 T = se.getT();
        GeometryMath_F64.mult(R, origPt, tranPt);
        GeometryMath_F64.add(tranPt, T, tranPt);
        return tranPt;
    }

    public static Point3D_F64 transformReverse(Se3_F64 se, Point3D_F64 origPt, Point3D_F64 tranPt) {
        if (tranPt == null) {
            tranPt = new Point3D_F64();
        }
        DenseMatrix64F R = se.getR();
        Vector3D_F64 T = se.getT();
        GeometryMath_F64.sub(origPt, T, tranPt);
        GeometryMath_F64.multTran(R, tranPt, tranPt);
        return tranPt;
    }
}

