/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.calib;

import boofcv.abst.calib.ConfigSquareGrid;
import boofcv.abst.calib.PlanarCalibrationDetector;
import boofcv.alg.feature.detect.InvalidCalibrationTarget;
import boofcv.alg.feature.detect.grid.AutoThresholdCalibrationGrid;
import boofcv.alg.feature.detect.grid.DetectSquareCalibrationPoints;
import boofcv.alg.feature.detect.grid.RefineCalibrationGridCorner;
import boofcv.alg.feature.detect.grid.UtilCalibrationGrid;
import boofcv.alg.feature.detect.grid.refine.WrapRefineCornerSegmentFit;
import boofcv.alg.feature.detect.quadblob.OrderPointsIntoGrid;
import boofcv.alg.feature.detect.quadblob.QuadBlob;
import boofcv.struct.image.ImageFloat32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class WrapPlanarSquareGridTarget
implements PlanarCalibrationDetector {
    int squareColumns;
    int pointColumns;
    int pointRows;
    RefineCalibrationGridCorner refine;
    AutoThresholdCalibrationGrid autoThreshold;
    DetectSquareCalibrationPoints detect;
    List<Point2D_F64> ret;
    OrderPointsIntoGrid orderAlg = new OrderPointsIntoGrid();

    public WrapPlanarSquareGridTarget(ConfigSquareGrid config) {
        this.refine = new WrapRefineCornerSegmentFit();
        this.squareColumns = config.numCols;
        this.pointColumns = (this.squareColumns / 2 + 1) * 2;
        this.pointRows = (config.numRows / 2 + 1) * 2;
        this.detect = new DetectSquareCalibrationPoints(500, config.relativeSizeThreshold, this.squareColumns, config.numRows);
        this.autoThreshold = new AutoThresholdCalibrationGrid(config.binaryThreshold);
    }

    @Override
    public boolean process(ImageFloat32 input) {
        if (!this.autoThreshold.process(this.detect, input)) {
            return false;
        }
        try {
            List<QuadBlob> squares = this.detect.getInterestSquares();
            this.refine.refine(squares, input);
            ArrayList<Point2D_F64> unordered = new ArrayList<Point2D_F64>();
            for (QuadBlob b : squares) {
                for (Point2D_F64 p : b.subpixel) {
                    unordered.add(p);
                }
            }
            this.orderAlg.process(unordered);
            this.ret = UtilCalibrationGrid.rotatePoints(this.orderAlg.getOrdered(), this.orderAlg.getNumRows(), this.orderAlg.getNumCols(), this.pointRows, this.pointColumns);
        }
        catch (InvalidCalibrationTarget e) {
            return false;
        }
        return this.ret != null;
    }

    @Override
    public List<Point2D_F64> getPoints() {
        return this.ret;
    }

    public AutoThresholdCalibrationGrid getAutoThreshold() {
        return this.autoThreshold;
    }

    public RefineCalibrationGridCorner getRefine() {
        return this.refine;
    }

    public DetectSquareCalibrationPoints getDetect() {
        return this.detect;
    }
}

