/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;

public abstract class WrapScaleToCharacteristic<T extends ImageSingleBand, D extends ImageSingleBand>
implements DescribeRegionPoint<T, TupleDesc_F64> {
    protected ImageGradient<T, D> gradient;
    protected T image;
    protected T scaledImage;
    protected D scaledDerivX;
    protected D scaledDerivY;
    int steerR;

    public WrapScaleToCharacteristic(int radiusR, ImageGradient<T, D> gradient, Class<T> inputType, Class<D> derivType) {
        this.gradient = gradient;
        this.steerR = radiusR;
        int w = this.steerR * 2 + 1 + 2;
        this.scaledImage = GeneralizedImageOps.createSingleBand(inputType, w, w);
        this.scaledDerivX = GeneralizedImageOps.createSingleBand(derivType, w, w);
        this.scaledDerivY = GeneralizedImageOps.createSingleBand(derivType, w, w);
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.getDescriptionLength());
    }

    @Override
    public void setImage(T image) {
        this.image = image;
    }

    @Override
    public boolean isInBounds(double x, double y, double orientation, double scale) {
        int r = (int)Math.ceil(scale * 3.0) + 1;
        return BoofMiscOps.checkInside(this.image, (int)x, (int)y, r + 1);
    }

    @Override
    public TupleDesc_F64 process(double x, double y, double theta, double scale, TupleDesc_F64 ret) {
        if (ret == null) {
            ret = this.createDescription();
        }
        int r = (int)Math.ceil(scale * 3.0) + 1;
        int pixelX = (int)x;
        int pixelY = (int)y;
        ImageRectangle area = new ImageRectangle(pixelX - r, pixelY - r, pixelX + r + 1, pixelY + r + 1);
        ImageBase subImage = ((ImageSingleBand)this.image).subimage(area.x0, area.y0, area.x1, area.y1);
        DistortImageOps.scale(subImage, this.scaledImage, TypeInterpolate.BILINEAR);
        this.gradient.process(this.scaledImage, this.scaledDerivX, this.scaledDerivY);
        this.describe(this.steerR + 1, this.steerR + 1, theta, ret);
        return ret;
    }

    protected abstract void describe(int var1, int var2, double var3, TupleDesc_F64 var5);

    @Override
    public boolean requiresScale() {
        return true;
    }

    @Override
    public boolean requiresOrientation() {
        return true;
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }
}

