/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.HoughTransformLineFootOfNorm;
import boofcv.alg.feature.detect.line.ImageLinePruneMerge;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.struct.FastQueue;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.line.LineParametric2D_F32;
import java.util.ArrayList;
import java.util.List;

public class DetectLineHoughFootSubimage<I extends ImageSingleBand, D extends ImageSingleBand>
implements DetectLine<I> {
    int totalHorizontalDivisions;
    int totalVerticalDivisions;
    HoughTransformLineFootOfNorm alg;
    ImageGradient<I, D> gradient;
    float thresholdEdge;
    D derivX;
    D derivY;
    ImageFloat32 intensity = new ImageFloat32(1, 1);
    ImageUInt8 binary = new ImageUInt8(1, 1);
    ImageLinePruneMerge post = new ImageLinePruneMerge();
    int maxLines;

    public DetectLineHoughFootSubimage(int localMaxRadius, int minCounts, int minDistanceFromOrigin, float thresholdEdge, int totalHorizontalDivisions, int totalVerticalDivisions, int maxLines, ImageGradient<I, D> gradient) {
        this.gradient = gradient;
        this.thresholdEdge = thresholdEdge;
        this.totalHorizontalDivisions = totalHorizontalDivisions;
        this.totalVerticalDivisions = totalVerticalDivisions;
        this.maxLines = maxLines;
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmaxCandidate(new ConfigExtract(localMaxRadius, minCounts, 0, false));
        this.alg = new HoughTransformLineFootOfNorm(extractor, minDistanceFromOrigin);
        this.derivX = GeneralizedImageOps.createSingleBand(gradient.getDerivType(), 1, 1);
        this.derivY = GeneralizedImageOps.createSingleBand(gradient.getDerivType(), 1, 1);
    }

    @Override
    public List<LineParametric2D_F32> detect(I input) {
        ((ImageSingleBand)this.derivX).reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        ((ImageSingleBand)this.derivY).reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.intensity.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.binary.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.gradient.process(input, this.derivX, this.derivY);
        GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.intensity);
        ThresholdImageOps.threshold(this.intensity, this.binary, this.thresholdEdge, false);
        ArrayList<LineParametric2D_F32> ret = new ArrayList();
        this.post.reset();
        for (int i = 0; i < this.totalVerticalDivisions; ++i) {
            int y0 = ((ImageSingleBand)input).height * i / this.totalVerticalDivisions;
            int y1 = ((ImageSingleBand)input).height * (i + 1) / this.totalVerticalDivisions;
            for (int j = 0; j < this.totalHorizontalDivisions; ++j) {
                int x0 = ((ImageSingleBand)input).width * j / this.totalVerticalDivisions;
                int x1 = ((ImageSingleBand)input).width * (j + 1) / this.totalVerticalDivisions;
                this.processSubimage(x0, y0, x1, y1, ret);
            }
        }
        ret = this.pruneLines(input);
        return ret;
    }

    private List<LineParametric2D_F32> pruneLines(I input) {
        this.post.pruneSimilar(0.12566371f, 10.0f, ((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.post.pruneNBest(this.maxLines);
        return this.post.createList();
    }

    private void processSubimage(int x0, int y0, int x1, int y1, List<LineParametric2D_F32> found) {
        ImageBase derivX = ((ImageSingleBand)this.derivX).subimage(x0, y0, x1, y1);
        ImageBase derivY = ((ImageSingleBand)this.derivY).subimage(x0, y0, x1, y1);
        ImageUInt8 binary = (ImageUInt8)this.binary.subimage(x0, y0, x1, y1);
        this.alg.transform(derivX, derivY, binary);
        FastQueue<LineParametric2D_F32> lines = this.alg.extractLines();
        float[] intensity = this.alg.getFoundIntensity();
        for (int i = 0; i < lines.size; ++i) {
            LineParametric2D_F32 l = lines.get(i).copy();
            l.p.x += (float)x0;
            l.p.y += (float)y0;
            found.add(l);
            this.post.add(l, intensity[i]);
        }
    }

    public HoughTransformLineFootOfNorm getTransform() {
        return this.alg;
    }

    public D getDerivX() {
        return this.derivX;
    }

    public D getDerivY() {
        return this.derivY;
    }

    public ImageFloat32 getEdgeIntensity() {
        return this.intensity;
    }

    public ImageUInt8 getBinary() {
        return this.binary;
    }
}

