/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.tracker;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.tracker.DdaFeatureManager;
import boofcv.abst.feature.tracker.DetectDescribeAssociate;
import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.feature.tracker.PointTrackerTwoPass;
import boofcv.struct.FastQueue;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;

public class DetectDescribeAssociateTwoPass<I extends ImageSingleBand, Desc extends TupleDesc>
extends DetectDescribeAssociate<I, Desc>
implements PointTrackerTwoPass<I> {
    AssociateDescription2D<Desc> associate2;
    boolean sourceSet2;

    public DetectDescribeAssociateTwoPass(DdaFeatureManager<I, Desc> manager, AssociateDescription2D<Desc> associate, AssociateDescription2D<Desc> associate2, boolean updateDescription) {
        super(manager, associate, updateDescription);
        this.associate2 = associate2;
    }

    @Override
    public void process(I input) {
        this.sourceSet2 = false;
        this.tracksActive.clear();
        this.tracksInactive.clear();
        this.tracksDropped.clear();
        this.tracksNew.clear();
        this.featDst.reset();
        this.locDst.reset();
        this.manager.detectFeatures(input, this.locDst, this.featDst);
        if (!this.tracksAll.isEmpty()) {
            this.putIntoSrcList();
            this.associate.setSource(this.locSrc, this.featSrc);
            this.associate.setDestination(this.locDst, this.featDst);
            this.associate.associate();
            this.updateTrackLocation(this.associate.getMatches());
        }
    }

    @Override
    public void performSecondPass() {
        if (this.tracksAll.isEmpty()) {
            return;
        }
        if (this.associate2 != this.associate && !this.sourceSet2) {
            this.sourceSet2 = true;
            this.associate.setSource(this.locSrc, this.featSrc);
        }
        this.associate2.setDestination(this.locDst, this.featDst);
        this.associate2.associate();
        this.updateTrackLocation(this.associate2.getMatches());
    }

    @Override
    public void finishTracking() {
        if (this.tracksAll.isEmpty()) {
            return;
        }
        this.tracksActive.clear();
        this.updateTrackState(this.matches);
        for (int i = 0; i < this.tracksAll.size(); ++i) {
            if (this.isAssociated[i]) continue;
            this.tracksInactive.add(this.tracksAll.get(i));
        }
    }

    protected void updateTrackLocation(FastQueue<AssociatedIndex> matches) {
        this.tracksActive.clear();
        for (int i = 0; i < matches.size; ++i) {
            AssociatedIndex indexes = ((AssociatedIndex[])matches.data)[i];
            PointTrack track = (PointTrack)((Object)this.tracksAll.get(indexes.src));
            Point2D_F64 loc = ((Point2D_F64[])this.locDst.data)[indexes.dst];
            track.set(loc.x, loc.y);
            this.tracksActive.add(track);
        }
        this.matches = matches;
    }

    @Override
    public void setHint(double pixelX, double pixelY, PointTrack track) {
        track.x = pixelX;
        track.y = pixelY;
    }
}

