/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;

public class InputSanityCheck {
    public static <T extends ImageSingleBand> T checkReshape(T target, ImageSingleBand testImage, Class<T> targetType) {
        if (target == null) {
            return GeneralizedImageOps.createSingleBand(targetType, testImage.width, testImage.height);
        }
        if (target.width != testImage.width || target.height != testImage.height) {
            target.reshape(testImage.width, testImage.height);
        }
        return target;
    }

    public static <T extends ImageSingleBand> T checkDeclare(T input, T output) {
        if (output == null) {
            output = (ImageSingleBand)input._createNew(input.width, input.height);
        } else if (output.width != input.width || output.height != input.height) {
            throw new IllegalArgumentException("Width and/or height of input and output do not match.");
        }
        return output;
    }

    public static <T extends ImageSingleBand> T checkDeclare(ImageSingleBand<?> input, T output, Class<T> outputType) {
        if (output == null) {
            output = GeneralizedImageOps.createSingleBand(outputType, input.width, input.height);
        } else if (output.width != input.width || output.height != input.height) {
            throw new IllegalArgumentException("Width and/or height of input and output do not match.");
        }
        return output;
    }

    public static void checkSameShape(ImageBase<?> imgA, ImageBase<?> imgB) {
        if (imgA.width != imgB.width) {
            throw new IllegalArgumentException("Image widths do not match.");
        }
        if (imgA.height != imgB.height) {
            throw new IllegalArgumentException("Image heights do not match.");
        }
    }

    public static void checkSameShape(ImageBase<?> imgA, ImageBase<?> imgB, ImageBase<?> imgC) {
        if (imgA.width != imgB.width || imgA.width != imgC.width) {
            throw new IllegalArgumentException("Image widths do not match.");
        }
        if (imgA.height != imgB.height || imgA.height != imgC.height) {
            throw new IllegalArgumentException("Image heights do not match.");
        }
    }

    public static void checkSameShape(ImageBase<?> imgA, ImageBase<?> imgB, ImageBase<?> imgC, ImageBase<?> imgD) {
        if (imgA.width != imgB.width || imgA.width != imgC.width || imgA.width != imgD.width) {
            throw new IllegalArgumentException("Image widths do not match.");
        }
        if (imgA.height != imgB.height || imgA.height != imgC.height || imgA.height != imgD.height) {
            throw new IllegalArgumentException("Image heights do not match.");
        }
    }

    public static void checkSameShape(ImageBase<?> imgA, ImageBase<?> imgB, ImageBase<?> imgC, ImageBase<?> imgD, ImageBase<?> imgE) {
        if (imgA.width != imgB.width || imgA.width != imgC.width || imgA.width != imgD.width || imgA.width != imgE.width) {
            throw new IllegalArgumentException("Image widths do not match.");
        }
        if (imgA.height != imgB.height || imgA.height != imgC.height || imgA.height != imgD.height || imgA.height != imgE.height) {
            throw new IllegalArgumentException("Image heights do not match.");
        }
    }
}

