/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_I32;

public abstract class DescribePointBinaryCompare<T extends ImageSingleBand> {
    protected BinaryCompareDefinition_I32 definition;
    protected T image;
    private int[] offsets = new int[0];
    protected int[] offsetsA = new int[0];
    protected int[] offsetsB = new int[0];

    public DescribePointBinaryCompare(BinaryCompareDefinition_I32 definition) {
        this.definition = definition;
        this.offsets = new int[definition.samplePoints.length];
        this.offsetsA = new int[definition.compare.length];
        this.offsetsB = new int[definition.compare.length];
    }

    public void setImage(T image) {
        int i;
        this.image = image;
        for (i = 0; i < this.definition.samplePoints.length; ++i) {
            Point2D_I32 a = this.definition.samplePoints[i];
            this.offsets[i] = ((ImageSingleBand)image).stride * a.y + a.x;
        }
        for (i = 0; i < this.definition.compare.length; ++i) {
            Point2D_I32 p = this.definition.compare[i];
            this.offsetsA[i] = this.offsets[p.x];
            this.offsetsB[i] = this.offsets[p.y];
        }
    }

    public void process(int c_x, int c_y, TupleDesc_B feature) {
        if (BoofMiscOps.checkInside(this.image, c_x, c_y, this.definition.radius)) {
            this.processInside(c_x, c_y, feature);
        } else {
            this.processBorder(c_x, c_y, feature);
        }
    }

    public abstract void processInside(int var1, int var2, TupleDesc_B var3);

    public abstract void processBorder(int var1, int var2, TupleDesc_B var3);

    public BinaryCompareDefinition_I32 getDefinition() {
        return this.definition;
    }
}

