/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.chess;

import boofcv.alg.feature.detect.grid.ConnectGridSquares;
import boofcv.alg.feature.detect.quadblob.DetectQuadBlobsBinary;
import boofcv.alg.feature.detect.quadblob.QuadBlob;
import boofcv.struct.FastQueue;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageUInt8;
import georegression.geometry.UtilPoint2D_I32;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class DetectChessSquaresBinary {
    private DetectQuadBlobsBinary detectBlobs;
    private int expectedBlobs;
    private int numRows;
    private int numCols;
    private ImageRectangle boundRect = new ImageRectangle();
    private List<QuadBlob> graphBlobs;
    FastQueue<Point2D_I32> corners = new FastQueue<Point2D_I32>(Point2D_I32.class, true);

    public DetectChessSquaresBinary(int numCols, int numRows, int minContourSize) {
        this.numRows = numRows;
        this.numCols = numCols;
        int blackCols = numCols / 2 + numCols % 2;
        int blackRows = numRows / 2 + numRows % 2;
        int innerCols = numCols / 2;
        int innerRows = numRows / 2;
        this.expectedBlobs = blackCols * blackRows + innerCols * innerRows;
        this.setMinimumContourSize(minContourSize);
    }

    public boolean process(ImageUInt8 binary) {
        this.graphBlobs = null;
        if (!this.detectBlobs.process(binary)) {
            return false;
        }
        this.graphBlobs = this.detectBlobs.getDetected();
        DetectChessSquaresBinary.connect(this.graphBlobs);
        this.graphBlobs = ConnectGridSquares.pruneSmallIslands(this.graphBlobs);
        if (this.graphBlobs.size() != this.expectedBlobs) {
            return false;
        }
        if (!this.checkGraphStructure(this.graphBlobs)) {
            return false;
        }
        this.findBoundingRectangle(this.graphBlobs);
        return true;
    }

    public static void connect(List<QuadBlob> blobs) {
        QuadBlob a;
        int i;
        for (i = 0; i < blobs.size(); ++i) {
            a = blobs.get(i);
            double tol = Math.max(a.largestSide / 2.0, 10.0);
            if (a.corners.size() != 4) {
                throw new RuntimeException("WTF is this doing here?");
            }
            for (int indexA = 0; indexA < 4; ++indexA) {
                Point2D_I32 ac = a.corners.get(indexA);
                QuadBlob match = null;
                double bestScore = Double.MAX_VALUE;
                for (int j = 0; j < blobs.size(); ++j) {
                    if (j == i) continue;
                    QuadBlob b = blobs.get(j);
                    for (int indexB = 0; indexB < 4; ++indexB) {
                        Point2D_I32 bc = b.corners.get(indexB);
                        double d = UtilPoint2D_I32.distance((Point2D_I32)ac, (Point2D_I32)bc);
                        if (!(d < bestScore)) continue;
                        match = b;
                        bestScore = d;
                    }
                }
                if (match == null || !(bestScore < tol)) continue;
                a.conn.add(match);
            }
        }
        for (i = 0; i < blobs.size(); ++i) {
            a = blobs.get(i);
            int j = 0;
            while (j < a.conn.size()) {
                QuadBlob b = a.conn.get(j);
                if (!b.conn.contains(a)) {
                    a.conn.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }

    private void findBoundingRectangle(List<QuadBlob> blobs) {
        this.boundRect.x0 = Integer.MAX_VALUE;
        this.boundRect.x1 = -2147483647;
        this.boundRect.y0 = Integer.MAX_VALUE;
        this.boundRect.y1 = -2147483647;
        for (QuadBlob b : blobs) {
            for (Point2D_I32 c : b.corners) {
                if (c.x < this.boundRect.x0) {
                    this.boundRect.x0 = c.x;
                }
                if (c.x > this.boundRect.x1) {
                    this.boundRect.x1 = c.x;
                }
                if (c.y < this.boundRect.y0) {
                    this.boundRect.y0 = c.y;
                }
                if (c.y <= this.boundRect.y1) continue;
                this.boundRect.y1 = c.y;
            }
        }
    }

    public boolean checkGraphStructure(List<QuadBlob> blobs) {
        int[] conn = new int[5];
        for (QuadBlob b : blobs) {
            int n = b.conn.size();
            conn[n] = conn[n] + 1;
        }
        if (conn[3] != 0) {
            return false;
        }
        if (this.numCols == 1 && this.numRows == 1) {
            if (conn[0] != 1) {
                return false;
            }
            if (conn[1] != 0) {
                return false;
            }
            if (conn[2] != 0) {
                return false;
            }
        } else {
            if (conn[0] != 0) {
                return false;
            }
            if (this.numCols % 2 == 1 && this.numRows % 2 == 1) {
                if (conn[1] != 4) {
                    return false;
                }
                if (conn[2] != 2 * (this.numCols / 2 - 1) + 2 * (this.numRows / 2 - 1)) {
                    return false;
                }
            } else if (this.numCols % 2 == 1 || this.numRows % 2 == 1) {
                if (this.numRows % 2 == 0) {
                    int tmp = this.numRows;
                    this.numRows = this.numCols;
                    this.numCols = tmp;
                }
                if (conn[1] != 2) {
                    return false;
                }
                if (conn[2] != this.numRows - 2 + 2 * (this.numCols / 2 - 1)) {
                    return false;
                }
            } else if (this.numRows % 2 == 1) {
                if (conn[1] != 1 + this.numCols % 2 + this.numRows % 2 + (this.numCols + this.numRows + 1) % 2) {
                    return false;
                }
                if (conn[2] != 2 * (this.numCols / 2 - 1) + 2 * (this.numRows / 2 - 1)) {
                    return false;
                }
            } else {
                if (conn[1] != 2) {
                    return false;
                }
                if (this.numCols == 2 || this.numRows == 2 ? conn[2] != Math.max(this.numCols, this.numRows) - 2 : conn[2] != 2 * (this.numCols / 2 - 1) + 2 * (this.numRows / 2 - 1)) {
                    return false;
                }
            }
        }
        return conn[4] == this.expectedBlobs - conn[0] - conn[1] - conn[2];
    }

    public void setMinimumContourSize(int minContourSize) {
        this.detectBlobs = new DetectQuadBlobsBinary(minContourSize, 0.25, this.expectedBlobs);
    }

    public DetectQuadBlobsBinary getDetectBlobs() {
        return this.detectBlobs;
    }

    public List<QuadBlob> getGraphBlobs() {
        return this.graphBlobs;
    }

    public ImageRectangle getBoundRect() {
        return this.boundRect;
    }

    public List<Point2D_I32> getCandidatePoints() {
        this.corners.reset();
        for (QuadBlob b : this.graphBlobs) {
            for (QuadBlob c : b.conn) {
                Point2D_I32 best = null;
                double bestDistance = Double.MAX_VALUE;
                for (Point2D_I32 p : b.corners) {
                    int d = p.distance2(c.center);
                    if (!((double)d < bestDistance)) continue;
                    bestDistance = d;
                    best = p;
                }
                this.corners.grow().set(best);
            }
        }
        return this.corners.toList();
    }
}

