/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.filter.convolve.ConvolveNormalized;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;

public abstract class ImplSsdCornerWeighted_S16
implements GradientCornerIntensity<ImageSInt16> {
    int radius;
    Kernel1D_I32 kernel;
    ImageSInt32 imgXX = new ImageSInt32(1, 1);
    ImageSInt32 imgYY = new ImageSInt32(1, 1);
    ImageSInt32 imgXY = new ImageSInt32(1, 1);
    ImageSInt32 temp = new ImageSInt32(1, 1);
    protected int totalXX;
    protected int totalYY;
    protected int totalXY;

    public ImplSsdCornerWeighted_S16(int radius) {
        this.radius = radius;
        this.kernel = FactoryKernelGaussian.gaussian(Kernel1D_I32.class, -1.0, radius);
    }

    @Override
    public void process(ImageSInt16 derivX, ImageSInt16 derivY, ImageFloat32 intensity) {
        int y;
        InputSanityCheck.checkSameShape(derivX, derivY, intensity);
        int w = derivX.width;
        int h = derivX.height;
        this.imgXX.reshape(w, h);
        this.imgYY.reshape(w, h);
        this.imgXY.reshape(w, h);
        this.temp.reshape(w, h);
        intensity.reshape(w, h);
        int index = 0;
        for (y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int x = 0;
            while (x < w) {
                short dx = derivX.data[indexX++];
                short dy = derivY.data[indexY++];
                this.imgXX.data[index] = dx * dx;
                this.imgYY.data[index] = dy * dy;
                this.imgXY.data[index] = dx * dy;
                ++x;
                ++index;
            }
        }
        this.blur(this.imgXX, this.temp);
        this.blur(this.imgYY, this.temp);
        this.blur(this.imgXY, this.temp);
        index = 0;
        for (y = 0; y < h; ++y) {
            int x = 0;
            while (x < w) {
                this.totalXX = this.imgXX.data[index];
                this.totalYY = this.imgYY.data[index];
                this.totalXY = this.imgXY.data[index];
                intensity.data[index] = this.computeResponse();
                ++x;
                ++index;
            }
        }
    }

    protected abstract float computeResponse();

    private void blur(ImageSInt32 image, ImageSInt32 temp) {
        ConvolveNormalized.horizontal(this.kernel, image, temp);
        ConvolveNormalized.vertical(this.kernel, temp, image);
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public int getIgnoreBorder() {
        return 0;
    }
}

