/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointScaleSpacePyramid;
import boofcv.abst.filter.ImageFunctionSparse;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.struct.QueueCorner;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.PyramidFloat;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;

public class FeatureLaplacePyramid<T extends ImageSingleBand, D extends ImageSingleBand>
implements InterestPointScaleSpacePyramid<T> {
    private ImageFunctionSparse<T> sparseLaplace;
    private GeneralFeatureDetector<T, D> detector;
    private float baseThreshold;
    protected int spaceIndex = 0;
    protected List<Point2D_I16>[] maximums;
    protected List<ScalePoint> foundPoints = new ArrayList<ScalePoint>();
    protected AnyImageDerivative<T, D> computeDerivative;
    protected double scalePower;

    public FeatureLaplacePyramid(GeneralFeatureDetector<T, D> detector, ImageFunctionSparse<T> sparseLaplace, AnyImageDerivative<T, D> computeDerivative, double scalePower) {
        this.detector = detector;
        this.baseThreshold = detector.getThreshold();
        this.computeDerivative = computeDerivative;
        this.sparseLaplace = sparseLaplace;
        this.scalePower = scalePower;
    }

    @Override
    public void detect(PyramidFloat<T> ss) {
        this.spaceIndex = 0;
        if (this.maximums == null) {
            this.maximums = new List[3];
            this.maximums[0] = new ArrayList<Point2D_I16>();
            this.maximums[1] = new ArrayList<Point2D_I16>();
            this.maximums[2] = new ArrayList<Point2D_I16>();
        }
        this.foundPoints.clear();
        for (int i = 0; i < ss.getNumLayers(); ++i) {
            if (i > 0 && i < ss.getNumLayers() - 1) {
                this.detectCandidateFeatures(ss.getLayer(i), ss.getSigma(i));
            }
            ++this.spaceIndex;
            if (this.spaceIndex >= 3) {
                this.spaceIndex = 0;
            }
            if (i < 2) continue;
            this.findLocalScaleSpaceMax(ss, i - 1);
        }
    }

    private void detectCandidateFeatures(T image, double sigma) {
        int i;
        QueueCorner q;
        float scaleThreshold = (float)((double)this.baseThreshold / Math.pow(sigma, this.scalePower));
        this.detector.setThreshold(scaleThreshold);
        this.computeDerivative.setInput(image);
        Object derivX = null;
        Object derivY = null;
        Object derivXX = null;
        Object derivYY = null;
        Object derivXY = null;
        if (this.detector.getRequiresGradient()) {
            derivX = this.computeDerivative.getDerivative(true);
            derivY = this.computeDerivative.getDerivative(false);
        }
        if (this.detector.getRequiresHessian()) {
            derivXX = this.computeDerivative.getDerivative(true, true);
            derivYY = this.computeDerivative.getDerivative(false, false);
            derivXY = this.computeDerivative.getDerivative(true, false);
        }
        this.detector.process(image, derivX, derivY, derivXX, derivYY, derivXY);
        List<Point2D_I16> m = this.maximums[this.spaceIndex];
        m.clear();
        if (this.detector.isDetectMaximums()) {
            q = this.detector.getMaximums();
            for (i = 0; i < q.size; ++i) {
                m.add(((Point2D_I16)q.get(i)).copy());
            }
        }
        if (this.detector.isDetectMinimums()) {
            q = this.detector.getMinimums();
            for (i = 0; i < q.size; ++i) {
                m.add(((Point2D_I16)q.get(i)).copy());
            }
        }
    }

    protected void findLocalScaleSpaceMax(PyramidFloat<T> ss, int layerID) {
        int index1 = (this.spaceIndex + 1) % 3;
        List<Point2D_I16> candidates = this.maximums[index1];
        float scale0 = (float)ss.scale[layerID - 1];
        float scale1 = (float)ss.scale[layerID];
        float scale2 = (float)ss.scale[layerID + 1];
        float sigma0 = (float)ss.getSigma(layerID - 1);
        float sigma1 = (float)ss.getSigma(layerID);
        float sigma2 = (float)ss.getSigma(layerID + 1);
        float ss0 = (float)(Math.pow(sigma0, 1.5) / (double)scale0);
        float ss1 = (float)(Math.pow(sigma1, 1.5) / (double)scale1);
        float ss2 = (float)(Math.pow(sigma2, 1.5) / (double)scale2);
        for (Point2D_I16 c : candidates) {
            this.sparseLaplace.setImage(ss.getLayer(layerID));
            float val = ss1 * (float)this.sparseLaplace.compute(c.x, c.y);
            float adj = Math.signum(val);
            int x0 = (int)((float)c.x * scale1 / scale0);
            int y0 = (int)((float)c.y * scale1 / scale0);
            int x2 = (int)((float)c.x * scale1 / scale2);
            int y2 = (int)((float)c.y * scale1 / scale2);
            if (!this.checkMax(ss.getLayer(layerID - 1), adj * ss0, val *= adj, x0, y0) || !this.checkMax(ss.getLayer(layerID + 1), adj * ss2, val, x2, y2)) continue;
            this.foundPoints.add(new ScalePoint((float)c.x * scale1, (float)c.y * scale1, sigma1));
        }
    }

    private boolean checkMax(T image, double adj, double bestScore, int c_x, int c_y) {
        this.sparseLaplace.setImage(image);
        boolean isMax = true;
        block0: for (int i = c_y - 1; i <= c_y + 1; ++i) {
            for (int j = c_x - 1; j <= c_x + 1; ++j) {
                double value = adj * this.sparseLaplace.compute(j, i);
                if (!(value >= bestScore)) continue;
                isMax = false;
                break block0;
            }
        }
        return isMax;
    }

    @Override
    public List<ScalePoint> getInterestPoints() {
        return this.foundPoints;
    }
}

