/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.line.gridline.Edgel;
import boofcv.struct.FastQueue;
import boofcv.struct.feature.MatrixOfList;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.geometry.UtilLine2D_F32;
import georegression.metric.ClosestPoint2D_F32;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LinePolar2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelMatcher;

public abstract class GridRansacLineDetector<D extends ImageSingleBand> {
    protected int regionSize;
    protected int minInlierSize;
    protected FastQueue<Edgel> edgels = new FastQueue<Edgel>(30, Edgel.class, true);
    protected int maxDetectLines;
    private ModelMatcher<LinePolar2D_F32, Edgel> robustMatcher;
    private MatrixOfList<LineSegment2D_F32> foundLines = new MatrixOfList(1, 1);

    public GridRansacLineDetector(int regionSize, int maxDetectLines, ModelMatcher<LinePolar2D_F32, Edgel> robustMatcher) {
        this.regionSize = regionSize;
        this.maxDetectLines = maxDetectLines;
        this.robustMatcher = robustMatcher;
        this.minInlierSize = 2 * regionSize / 3;
    }

    public void process(D derivX, D derivY, ImageUInt8 binaryEdges) {
        InputSanityCheck.checkSameShape(derivX, derivY, binaryEdges);
        int w = ((ImageSingleBand)derivX).width - this.regionSize + 1;
        int h = ((ImageSingleBand)derivY).height - this.regionSize + 1;
        this.foundLines.reshape(((ImageSingleBand)derivX).width / this.regionSize, ((ImageSingleBand)derivX).height / this.regionSize);
        this.foundLines.reset();
        for (int y = 0; y < h; y += this.regionSize) {
            int gridY = y / this.regionSize;
            int index = binaryEdges.startIndex + y * binaryEdges.stride;
            int x = 0;
            while (x < w) {
                int gridX = x / this.regionSize;
                this.detectEdgels(index, x, y, derivX, derivY, binaryEdges);
                this.findLinesInRegion(this.foundLines.get(gridX, gridY));
                x += this.regionSize;
                index += this.regionSize;
            }
        }
    }

    public MatrixOfList<LineSegment2D_F32> getFoundLines() {
        return this.foundLines;
    }

    protected abstract void detectEdgels(int var1, int var2, int var3, D var4, D var5, ImageUInt8 var6);

    private void findLinesInRegion(List<LineSegment2D_F32> gridLines) {
        List matchSet;
        List<Edgel> list = this.edgels.copyIntoList(null);
        int iterations = 0;
        while (iterations++ < this.maxDetectLines && this.robustMatcher.process(list) && (matchSet = this.robustMatcher.getMatchSet()).size() >= this.minInlierSize) {
            for (Edgel e : matchSet) {
                list.remove((Object)e);
            }
            gridLines.add(this.convertToLineSegment(matchSet, (LinePolar2D_F32)this.robustMatcher.getModel()));
        }
    }

    private LineSegment2D_F32 convertToLineSegment(List<Edgel> matchSet, LinePolar2D_F32 model) {
        float minT = Float.MAX_VALUE;
        float maxT = -3.4028235E38f;
        LineParametric2D_F32 line = UtilLine2D_F32.convert((LinePolar2D_F32)model, null);
        Point2D_F32 p = new Point2D_F32();
        for (Edgel e : matchSet) {
            p.set(e.x, e.y);
            float t = ClosestPoint2D_F32.closestPointT((LineParametric2D_F32)line, (Point2D_F32)e);
            if (minT > t) {
                minT = t;
            }
            if (!(maxT < t)) continue;
            maxT = t;
        }
        LineSegment2D_F32 segment = new LineSegment2D_F32();
        segment.a.x = line.p.x + line.slope.x * minT;
        segment.a.y = line.p.y + line.slope.y * minT;
        segment.b.x = line.p.x + line.slope.x * maxT;
        segment.b.y = line.p.y + line.slope.y * maxT;
        return segment;
    }
}

