/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.quadblob;

import boofcv.alg.feature.detect.InvalidCalibrationTarget;
import boofcv.alg.feature.detect.quadblob.FindBoundingQuadrilateral;
import georegression.metric.UtilAngle;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class OrderPointsIntoGrid {
    private List<Point2D_F64> ordered;
    List<Point2D_F64> targetCorners;
    private int numCols;
    private int numRows;

    public List<Point2D_F64> process(List<Point2D_F64> unordered) throws InvalidCalibrationTarget {
        ArrayList<Point2D_F64> internal = new ArrayList<Point2D_F64>(unordered);
        this.targetCorners = FindBoundingQuadrilateral.findCorners(internal);
        this.ordered = this.putBlobsIntoOrder(internal);
        return this.ordered;
    }

    private List<Point2D_F64> putBlobsIntoOrder(List<Point2D_F64> unordered) throws InvalidCalibrationTarget {
        int N = unordered.size();
        Point2D_F64 seed = this.targetCorners.get(0);
        ArrayList<Point2D_F64> orderedBlob = new ArrayList<Point2D_F64>();
        List<Point2D_F64> topRow = this.findLine(seed, this.targetCorners.get(1), unordered);
        List<Point2D_F64> leftCol = this.findLine(seed, this.targetCorners.get(3), unordered);
        List<Point2D_F64> rightCol = this.findLine(topRow.get(topRow.size() - 1), this.targetCorners.get(2), unordered);
        this.sanityCheckTarget(topRow, leftCol, rightCol, N);
        this.numRows = 1;
        this.numCols = topRow.size();
        while (true) {
            if (topRow.size() != this.numCols) {
                throw new InvalidCalibrationTarget("row with unexpected number of column");
            }
            orderedBlob.addAll(topRow);
            this.removeRow(topRow, unordered);
            leftCol.remove(0);
            rightCol.remove(0);
            if (unordered.size() <= 0) break;
            ++this.numRows;
            topRow = this.findLine(leftCol.get(0), rightCol.get(0), unordered);
        }
        return orderedBlob;
    }

    private void sanityCheckTarget(List<Point2D_F64> topRow, List<Point2D_F64> leftCol, List<Point2D_F64> rightCol, int totalPoints) throws InvalidCalibrationTarget {
        int rows;
        if (leftCol.size() != rightCol.size()) {
            throw new InvalidCalibrationTarget("Left and right columns have different length: " + leftCol.size() + " " + rightCol.size());
        }
        int cols = topRow.size();
        if (totalPoints != cols * (rows = leftCol.size())) {
            throw new InvalidCalibrationTarget("Total number of elements does not match number of rows/columns.");
        }
    }

    private void removeRow(List<Point2D_F64> row, List<Point2D_F64> all) {
        for (Point2D_F64 b : row) {
            if (all.remove(b)) continue;
            throw new RuntimeException("Bug");
        }
    }

    public List<Point2D_F64> findLine(Point2D_F64 startPt, Point2D_F64 target, List<Point2D_F64> candidates) {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        double targetAngle = Math.atan2(target.y - startPt.y, target.x - startPt.x);
        while (startPt != null) {
            ret.add(startPt);
            if (startPt == target) break;
            double best = Double.MAX_VALUE;
            Point2D_F64 found = null;
            for (Point2D_F64 c : candidates) {
                double dist;
                double angle;
                double acute;
                if (ret.contains(c) || !((acute = UtilAngle.dist((double)targetAngle, (double)(angle = Math.atan2(c.y - startPt.y, c.x - startPt.x)))) < 1.0471975511965976) || !((dist = 2.0 * c.distance((GeoTuple2D_F64)startPt) + c.distance((GeoTuple2D_F64)target)) < best)) continue;
                best = dist;
                found = c;
            }
            startPt = found;
        }
        return ret;
    }

    public List<Point2D_F64> getQuadrilateral() {
        return this.targetCorners;
    }

    public List<Point2D_F64> getOrdered() {
        return this.ordered;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public int getNumRows() {
        return this.numRows;
    }
}

