/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.template;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.feature.detect.template.TemplateMatchingIntensity;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.struct.FastQueue;
import boofcv.struct.QueueCorner;
import boofcv.struct.feature.Match;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.sorting.QuickSelectArray;

public class TemplateMatching<T extends ImageBase> {
    private TemplateMatchingIntensity<T> match;
    private NonMaxSuppression extractor;
    private T template;
    private int maxMatches;
    private QueueCorner candidates = new QueueCorner(10);
    private float[] scores = new float[10];
    private int[] indexes = new int[10];
    private FastQueue<Match> results = new FastQueue<Match>(10, Match.class, true);

    public TemplateMatching(TemplateMatchingIntensity<T> match) {
        this.match = match;
        this.extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(2, -3.4028235E38f, 0, true));
    }

    public void setMinimumSeparation(int radius) {
        this.extractor.setSearchRadius(radius);
    }

    public void setTemplate(T template, int maxMatches) {
        this.template = template;
        this.maxMatches = maxMatches;
        int w = Math.min(((ImageBase)template).width, ((ImageBase)template).height);
    }

    public void process(T image) {
        this.match.process(image, this.template);
        ImageFloat32 intensity = this.match.getIntensity();
        int offsetX = 0;
        int offsetY = 0;
        if (!this.match.isBorderProcessed()) {
            int x0 = this.match.getOffsetX();
            int x1 = ((ImageBase)image).width - (((ImageBase)this.template).width - offsetX);
            int y0 = this.match.getOffsetY();
            int y1 = ((ImageBase)image).height - (((ImageBase)this.template).height - offsetY);
            intensity = (ImageFloat32)intensity.subimage(x0, y0, x1, y1);
        } else {
            offsetX = this.match.getOffsetX();
            offsetY = this.match.getOffsetY();
        }
        this.candidates.reset();
        this.extractor.process(intensity, null, null, null, this.candidates);
        if (this.scores.length < this.candidates.size) {
            this.scores = new float[this.candidates.size];
            this.indexes = new int[this.candidates.size];
        }
        for (int i = 0; i < this.candidates.size; ++i) {
            Point2D_I16 p = (Point2D_I16)this.candidates.get(i);
            this.scores[i] = -intensity.get(p.x, p.y);
        }
        int N = Math.min(this.maxMatches, this.candidates.size);
        QuickSelectArray.selectIndex((float[])this.scores, (int)N, (int)this.candidates.size, (int[])this.indexes);
        this.results.reset();
        for (int i = 0; i < N; ++i) {
            Point2D_I16 p = (Point2D_I16)this.candidates.get(this.indexes[i]);
            Match m = this.results.grow();
            m.score = -this.scores[i];
            m.set(p.x - offsetX, p.y - offsetY);
        }
    }

    public FastQueue<Match> getResults() {
        return this.results;
    }
}

