/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation;

import boofcv.alg.feature.detect.interest.SiftImageScaleSpace;
import boofcv.misc.BoofMiscOps;
import boofcv.numerics.InterpolateArray;
import boofcv.struct.GrowQueue_F64;
import boofcv.struct.GrowQueue_I32;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageFloat32;

public class OrientationHistogramSift {
    private double sigmaToRadius;
    private double sigmaEnlarge;
    private double[] histogram;
    private double[] histogramX;
    private double[] histogramY;
    private double histAngleBin;
    private GrowQueue_I32 peaks = new GrowQueue_I32(10);
    private GrowQueue_F64 angles = new GrowQueue_F64(10);
    private double peakAngle;
    private ImageRectangle bound = new ImageRectangle();
    private int imageIndex;
    private double pixelScale;
    private SiftImageScaleSpace ss;
    private ImageFloat32 image;
    private ImageFloat32 derivX;
    private ImageFloat32 derivY;
    InterpolateArray approximateGauss;
    double approximateStep = 0.1;

    public OrientationHistogramSift(int histogramSize, double sigmaToRadius, double sigmaEnlarge) {
        this.histogram = new double[histogramSize];
        this.histogramX = new double[histogramSize];
        this.histogramY = new double[histogramSize];
        this.sigmaToRadius = sigmaToRadius;
        this.sigmaEnlarge = sigmaEnlarge;
        this.histAngleBin = Math.PI * 2 / (double)histogramSize;
        double[] samples = new double[(int)(16.0 / this.approximateStep)];
        for (int i = 0; i < samples.length; ++i) {
            double dx2 = (double)i * this.approximateStep;
            samples[i] = Math.exp(-0.5 * dx2);
        }
        this.approximateGauss = new InterpolateArray(samples);
    }

    public void setScaleSpace(SiftImageScaleSpace ss) {
        this.ss = ss;
    }

    public void process(double c_x, double c_y, double scale) {
        this.imageIndex = this.ss.scaleToImageIndex(scale);
        this.pixelScale = this.ss.imageIndexToPixelScale(this.imageIndex);
        this.image = this.ss.getPyramidLayer(this.imageIndex);
        this.derivX = this.ss.getDerivativeX(this.imageIndex);
        this.derivY = this.ss.getDerivativeY(this.imageIndex);
        int x = (int)(c_x / this.pixelScale + 0.5);
        int y = (int)(c_y / this.pixelScale + 0.5);
        double adjustedScale = scale / this.pixelScale;
        this.computeHistogram(x, y, adjustedScale);
        this.computeOrientations();
    }

    private void computeHistogram(int c_x, int c_y, double scale) {
        double localSigma = scale * this.sigmaEnlarge;
        int r = (int)Math.ceil(localSigma * this.sigmaToRadius);
        this.bound.x0 = c_x - r;
        this.bound.y0 = c_y - r;
        this.bound.x1 = c_x + r + 1;
        this.bound.y1 = c_y + r + 1;
        BoofMiscOps.boundRectangleInside(this.image, this.bound);
        for (int i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = 0.0;
            this.histogramX[i] = 0.0;
            this.histogramY[i] = 0.0;
        }
        for (int y = this.bound.y0; y < this.bound.y1; ++y) {
            int indexDX = this.derivX.startIndex + y * this.derivX.stride + this.bound.x0;
            int indexDY = this.derivY.startIndex + y * this.derivY.stride + this.bound.x0;
            for (int x = this.bound.x0; x < this.bound.x1; ++x) {
                float dx = this.derivX.data[indexDX++];
                float dy = this.derivY.data[indexDY++];
                double m = Math.sqrt(dx * dx + dy * dy);
                double theta = Math.atan2(dy, dx) + Math.PI;
                double w = this.computeWeight(x - c_x, y - c_y, localSigma);
                int h = (int)(theta / this.histAngleBin);
                if (h == this.histogram.length) {
                    h = 0;
                }
                int n = h;
                this.histogram[n] = this.histogram[n] + m * w;
                int n2 = h;
                this.histogramX[n2] = this.histogramX[n2] + (double)dx;
                int n3 = h;
                this.histogramY[n3] = this.histogramY[n3] + (double)dy;
            }
        }
    }

    private void computeOrientations() {
        int i;
        this.peaks.reset();
        double largest = 0.0;
        int largestIndex = -1;
        double before = this.histogram[this.histogram.length - 1];
        double current = this.histogram[0];
        for (i = 0; i < this.histogram.length; ++i) {
            double after = this.histogram[(i + 1) % this.histogram.length];
            if (current > before && current > after) {
                this.peaks.push(i);
                if (current > largest) {
                    largest = current;
                    largestIndex = i;
                }
            }
            before = current;
            current = after;
        }
        if (largestIndex < 0) {
            return;
        }
        this.angles.reset();
        for (i = 0; i < this.peaks.size; ++i) {
            int index = this.peaks.data[i];
            current = this.histogram[index];
            if (!(largest * 0.8 <= current)) continue;
            double angle = Math.atan2(this.histogramY[index], this.histogramX[index]);
            this.angles.push(angle);
            if (index != largestIndex) continue;
            this.peakAngle = angle;
        }
    }

    private double computeWeight(double deltaX, double deltaY, double sigma) {
        double d = (deltaX * deltaX + deltaY * deltaY) / (sigma * sigma) / this.approximateStep;
        if (this.approximateGauss.interpolate(d)) {
            return this.approximateGauss.value;
        }
        return 0.0;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public double getPixelScale() {
        return this.pixelScale;
    }

    public GrowQueue_F64 getOrientations() {
        return this.angles;
    }

    public double getPeakOrientation() {
        return this.peakAngle;
    }
}

