/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.shapes;

import boofcv.alg.feature.shapes.SplitMergeLineFit;
import boofcv.struct.GrowQueue_I32;
import georegression.metric.Distance2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class SplitMergeLineFitSegment
extends SplitMergeLineFit {
    public SplitMergeLineFitSegment(double toleranceSplit, double toleranceMerge, int maxIterations) {
        super(toleranceSplit, toleranceMerge, maxIterations);
    }

    @Override
    public void process(List<Point2D_I32> list) {
        this.splits.reset();
        this.contour = list;
        if (list.size() <= 2) {
            return;
        }
        this.splits.add(0);
        this.splitPixels(0, list.size() - 1);
        this.splits.add(list.size() - 1);
        for (int i = 0; i < this.maxIterations && this.mergeSegments() && this.splitSegments(); ++i) {
        }
    }

    protected void splitPixels(int indexStart, int indexStop) {
        if (indexStart + 1 >= indexStop) {
            return;
        }
        Point2D_I32 a = (Point2D_I32)this.contour.get(indexStart);
        Point2D_I32 c = (Point2D_I32)this.contour.get(indexStop);
        this.line.p.set((double)a.x, (double)a.y);
        this.line.slope.set((double)(c.x - a.x), (double)(c.y - a.y));
        int indexSplit = this.selectSplitOffset(indexStart, indexStop);
        if (indexSplit >= 0) {
            this.splitPixels(indexStart, indexSplit);
            this.splits.add(indexSplit);
            this.splitPixels(indexSplit, indexStop);
        }
    }

    protected boolean splitSegments() {
        boolean change = false;
        this.work.reset();
        for (int i = 0; i < this.splits.size - 1; ++i) {
            int start = this.splits.data[i];
            int end = this.splits.data[i + 1];
            Point2D_I32 a = (Point2D_I32)this.contour.get(start);
            Point2D_I32 b = (Point2D_I32)this.contour.get(end);
            this.line.p.set((double)a.x, (double)a.y);
            this.line.slope.set((double)(b.x - a.x), (double)(b.y - a.y));
            int bestIndex = this.selectSplitOffset(start, end);
            if (bestIndex >= 0) {
                change = true;
                this.work.add(start);
                this.work.add(bestIndex);
                continue;
            }
            this.work.add(start);
        }
        this.work.add(this.splits.data[this.splits.size - 1]);
        GrowQueue_I32 tmp = this.work;
        this.work = this.splits;
        this.splits = tmp;
        return change;
    }

    protected int selectSplitOffset(int indexStart, int indexEnd) {
        int bestIndex = -1;
        double bestDistanceSq = 0.0;
        for (int i = indexStart + 1; i < indexEnd; ++i) {
            Point2D_I32 b = (Point2D_I32)this.contour.get(i);
            this.point2D.set((double)b.x, (double)b.y);
            double dist = Distance2D_F64.distanceSq((LineParametric2D_F64)this.line, (Point2D_F64)this.point2D);
            if (!(dist > bestDistanceSq)) continue;
            bestDistanceSq = dist;
            bestIndex = i;
        }
        if (bestDistanceSq > this.toleranceSplitSq) {
            return bestIndex;
        }
        return -1;
    }

    protected boolean mergeSegments() {
        if (this.splits.size <= 2) {
            return false;
        }
        boolean change = false;
        this.work.reset();
        this.work.add(this.splits.data[0]);
        Point2D_I32 a = (Point2D_I32)this.contour.get(this.splits.data[0]);
        Point2D_I32 b = (Point2D_I32)this.contour.get(this.splits.data[1]);
        for (int i = 0; i < this.splits.size - 2; ++i) {
            Point2D_I32 c = (Point2D_I32)this.contour.get(this.splits.data[i + 2]);
            double theta = this.computeAcute(a, b, c);
            if (theta <= this.toleranceMerge) {
                change = true;
                b = c;
                continue;
            }
            this.work.add(this.splits.data[i + 1]);
            a = b;
            b = c;
        }
        this.work.add(this.splits.data[this.splits.size - 1]);
        GrowQueue_I32 tmp = this.work;
        this.work = this.splits;
        this.splits = tmp;
        return change;
    }
}

