/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.RodriguesRotationJacobian;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.RotationMatrixGenerator;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DenseMatrix64F;

public class Zhang99OptimizationJacobian
implements FunctionNtoMxN {
    RodriguesRotationJacobian rodJacobian = new RodriguesRotationJacobian();
    Rodrigues rodrigues = new Rodrigues();
    private int numParam;
    private int numFuncs;
    private List<Point3D_F64> grid = new ArrayList<Point3D_F64>();
    private int numObservedTargets;
    private boolean assumeZeroSkew;
    private Se3_F64 se = new Se3_F64();
    private Point3D_F64 cameraPt = new Point3D_F64();
    private Point2D_F64 normPt = new Point2D_F64();
    public double a;
    public double b;
    public double c;
    public double x0;
    public double y0;
    public double[] radial;
    int indexJacX;
    int indexJacY;
    Point3D_F64 Xdot = new Point3D_F64();

    public Zhang99OptimizationJacobian(boolean assumeZeroSkew, int numRadial, int numObservedTargets, List<Point2D_F64> grid) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.numObservedTargets = numObservedTargets;
        for (Point2D_F64 p : grid) {
            this.grid.add(new Point3D_F64(p.x, p.y, 0.0));
        }
        this.numParam = numRadial + 6 * numObservedTargets;
        this.numParam = assumeZeroSkew ? (this.numParam += 4) : (this.numParam += 5);
        this.numFuncs = numObservedTargets * grid.size() * 2;
        this.radial = new double[numRadial];
        if (assumeZeroSkew) {
            this.c = 0.0;
        }
    }

    public int getN() {
        return this.numParam;
    }

    public int getM() {
        return this.numFuncs;
    }

    public void process(double[] input, double[] output) {
        int index = 0;
        this.a = input[index++];
        this.b = input[index++];
        if (!this.assumeZeroSkew) {
            this.c = input[index++];
        }
        this.x0 = input[index++];
        this.y0 = input[index++];
        for (int i = 0; i < this.radial.length; ++i) {
            this.radial[i] = input[index++];
        }
        for (int indexView = 0; indexView < this.numObservedTargets; ++indexView) {
            double rodX = input[index++];
            double rodY = input[index++];
            double rodZ = input[index++];
            double tranX = input[index++];
            double tranY = input[index++];
            double tranZ = input[index++];
            this.rodrigues.setParamVector(rodX, rodY, rodZ);
            this.rodJacobian.process(rodX, rodY, rodZ);
            RotationMatrixGenerator.rodriguesToMatrix((Rodrigues)this.rodrigues, (DenseMatrix64F)this.se.getR());
            this.se.T.set(tranX, tranY, tranZ);
            for (int i = 0; i < this.grid.size(); ++i) {
                this.indexJacX = (2 * indexView * this.grid.size() + i * 2) * this.numParam;
                this.indexJacY = (2 * indexView * this.grid.size() + i * 2 + 1) * this.numParam;
                SePointOps_F64.transform((Se3_F64)this.se, (Point3D_F64)this.grid.get(i), (Point3D_F64)this.cameraPt);
                this.normPt.x = this.cameraPt.x / this.cameraPt.z;
                this.normPt.y = this.cameraPt.y / this.cameraPt.z;
                this.calibrationGradient(output);
                this.distortGradient(this.normPt, output);
                this.indexJacX += indexView * 6;
                this.indexJacY += indexView * 6;
                this.rodriguesGradient(this.rodJacobian.Rx, this.grid.get(i), this.cameraPt, this.normPt, output);
                this.rodriguesGradient(this.rodJacobian.Ry, this.grid.get(i), this.cameraPt, this.normPt, output);
                this.rodriguesGradient(this.rodJacobian.Rz, this.grid.get(i), this.cameraPt, this.normPt, output);
                this.translateGradient(this.cameraPt, this.normPt, output);
            }
        }
    }

    private void calibrationGradient(double[] output) {
        output[this.indexJacX++] = this.normPt.x;
        output[this.indexJacX++] = 0.0;
        if (!this.assumeZeroSkew) {
            output[this.indexJacX++] = this.normPt.y;
        }
        output[this.indexJacX++] = 1.0;
        output[this.indexJacX++] = 0.0;
        output[this.indexJacY++] = 0.0;
        output[this.indexJacY++] = this.normPt.y;
        if (!this.assumeZeroSkew) {
            output[this.indexJacY++] = 0.0;
        }
        output[this.indexJacY++] = 0.0;
        output[this.indexJacY++] = 1.0;
    }

    private void distortGradient(Point2D_F64 pt, double[] output) {
        double r2;
        double r = r2 = pt.x * pt.x + pt.y * pt.y;
        for (int i = 0; i < this.radial.length; ++i) {
            double xdot = pt.x * r;
            double ydot = pt.y * r;
            output[this.indexJacX++] = this.a * xdot + this.c * ydot;
            output[this.indexJacY++] = this.b * ydot;
            r *= r2;
        }
    }

    private void rodriguesGradient(DenseMatrix64F Rdot, Point3D_F64 X, Point3D_F64 cameraPt, Point2D_F64 normPt, double[] output) {
        double r2;
        double r = r2 = normPt.x * normPt.x + normPt.y * normPt.y;
        double rdev = 1.0;
        double sum = 0.0;
        double sumdot = 0.0;
        for (int i = 0; i < this.radial.length; ++i) {
            sum += this.radial[i] * r;
            sumdot += this.radial[i] * 2.0 * (double)(i + 1) * rdev;
            r *= r2;
            rdev *= r2;
        }
        GeometryMath_F64.mult((DenseMatrix64F)Rdot, (GeoTuple3D_F64)X, (GeoTuple3D_F64)this.Xdot);
        double r_dot = (normPt.x * this.Xdot.x + normPt.y * this.Xdot.y) / cameraPt.z - r2 * this.Xdot.z / cameraPt.z;
        double n_dot_x = (-normPt.x * this.Xdot.z + this.Xdot.x) / cameraPt.z;
        double n_dot_y = (-normPt.y * this.Xdot.z + this.Xdot.y) / cameraPt.z;
        double xdot = sumdot * r_dot * normPt.x + (1.0 + sum) * n_dot_x;
        double ydot = sumdot * r_dot * normPt.y + (1.0 + sum) * n_dot_y;
        output[this.indexJacX++] = this.a * xdot + this.c * ydot;
        output[this.indexJacY++] = this.b * ydot;
    }

    private void translateGradient(Point3D_F64 cameraPt, Point2D_F64 normPt, double[] output) {
        double r2;
        double r = r2 = normPt.x * normPt.x + normPt.y * normPt.y;
        double rdev = 1.0;
        double sum = 0.0;
        double sumdot = 0.0;
        for (int i = 0; i < this.radial.length; ++i) {
            sum += this.radial[i] * r;
            sumdot += this.radial[i] * 2.0 * (double)(i + 1) * rdev;
            r *= r2;
            rdev *= r2;
        }
        double xdot = sumdot * normPt.x * normPt.x / cameraPt.z + (1.0 + sum) / cameraPt.z;
        double ydot = sumdot * normPt.x * normPt.y / cameraPt.z;
        output[this.indexJacX++] = this.a * xdot + this.c * ydot;
        output[this.indexJacY++] = this.b * ydot;
        xdot = sumdot * normPt.y * normPt.x / cameraPt.z;
        ydot = sumdot * normPt.y * normPt.y / cameraPt.z + (1.0 + sum) / cameraPt.z;
        output[this.indexJacX++] = this.a * xdot + this.c * ydot;
        output[this.indexJacY++] = this.b * ydot;
        xdot = -sumdot * r2 * normPt.x / cameraPt.z;
        ydot = -sumdot * r2 * normPt.y / cameraPt.z;
        output[this.indexJacX++] = this.a * (xdot += -(1.0 + sum) * normPt.x / cameraPt.z) + this.c * (ydot += -(1.0 + sum) * normPt.y / cameraPt.z);
        output[this.indexJacY++] = this.b * ydot;
    }
}

