/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.f.HelperNister5;
import boofcv.struct.FastQueue;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.solver.impl.FindRealRootsSturm;
import org.ddogleg.solver.impl.WrapRealRootsSturm;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.LinearSolver;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class EssentialNister5 {
    private DenseMatrix64F Q = new DenseMatrix64F(5, 9);
    private DenseMatrix64F V = new DenseMatrix64F(9, 9);
    private SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)5, (int)9, (boolean)false, (boolean)true, (boolean)false);
    private HelperNister5 helper = new HelperNister5();
    private double[] X = new double[9];
    private double[] Y = new double[9];
    private double[] Z = new double[9];
    private double[] W = new double[9];
    private double x;
    private double y;
    private double z;
    LinearSolver<DenseMatrix64F> solver = LinearSolverFactory.linear((int)10);
    private DenseMatrix64F A1 = new DenseMatrix64F(10, 10);
    private DenseMatrix64F A2 = new DenseMatrix64F(10, 10);
    private DenseMatrix64F C = new DenseMatrix64F(10, 10);
    private FindRealRootsSturm sturm = new FindRealRootsSturm(11, -1.0, 1.0E-10, 20, 20);
    private PolynomialRoots findRoots = new WrapRealRootsSturm(this.sturm);
    private Polynomial poly = new Polynomial(11);

    public boolean process(List<AssociatedPair> points, FastQueue<DenseMatrix64F> solutions) {
        if (points.size() != 5) {
            throw new IllegalArgumentException("Exactly 5 points are required, not " + points.size());
        }
        solutions.reset();
        this.computeSpan(points);
        this.helper.setNullSpace(this.X, this.Y, this.Z, this.W);
        this.helper.setupA1(this.A1);
        this.helper.setupA2(this.A2);
        this.solver.setA((Matrix64F)this.A1);
        this.solver.solve((Matrix64F)this.A2, (Matrix64F)this.C);
        this.helper.setDeterminantVectors(this.C);
        this.helper.extractPolynomial(this.poly.getCoefficients());
        if (!this.findRoots.process(this.poly)) {
            return false;
        }
        for (Complex64F c : this.findRoots.getRoots()) {
            if (!c.isReal()) continue;
            this.solveForXandY(c.real);
            DenseMatrix64F E = solutions.grow();
            for (int i = 0; i < 9; ++i) {
                E.data[i] = this.x * this.X[i] + this.y * this.Y[i] + this.z * this.Z[i] + this.W[i];
            }
        }
        return true;
    }

    private void computeSpan(List<AssociatedPair> points) {
        int i;
        this.Q.reshape(points.size(), 9);
        int index = 0;
        for (i = 0; i < points.size(); ++i) {
            AssociatedPair p = points.get(i);
            Point2D_F64 a = p.p2;
            Point2D_F64 b = p.p1;
            this.Q.data[index++] = a.x * b.x;
            this.Q.data[index++] = a.x * b.y;
            this.Q.data[index++] = a.x;
            this.Q.data[index++] = a.y * b.x;
            this.Q.data[index++] = a.y * b.y;
            this.Q.data[index++] = a.y;
            this.Q.data[index++] = b.x;
            this.Q.data[index++] = b.y;
            this.Q.data[index++] = 1.0;
        }
        if (!this.svd.decompose((Matrix64F)this.Q)) {
            throw new RuntimeException("SVD should never fail, probably bad input");
        }
        this.svd.getV((Matrix64F)this.V, true);
        for (i = 0; i < 9; ++i) {
            this.X[i] = this.V.unsafe_get(5, i);
            this.Y[i] = this.V.unsafe_get(6, i);
            this.Z[i] = this.V.unsafe_get(7, i);
            this.W[i] = this.V.unsafe_get(8, i);
        }
    }

    private void solveForXandY(double z) {
        this.z = z;
        DenseMatrix64F A = new DenseMatrix64F(3, 2);
        DenseMatrix64F Y = new DenseMatrix64F(3, 1);
        A.data[0] = ((this.helper.K00 * z + this.helper.K01) * z + this.helper.K02) * z + this.helper.K03;
        A.data[1] = ((this.helper.K04 * z + this.helper.K05) * z + this.helper.K06) * z + this.helper.K07;
        Y.data[0] = (((this.helper.K08 * z + this.helper.K09) * z + this.helper.K10) * z + this.helper.K11) * z + this.helper.K12;
        A.data[2] = ((this.helper.L00 * z + this.helper.L01) * z + this.helper.L02) * z + this.helper.L03;
        A.data[3] = ((this.helper.L04 * z + this.helper.L05) * z + this.helper.L06) * z + this.helper.L07;
        Y.data[1] = (((this.helper.L08 * z + this.helper.L09) * z + this.helper.L10) * z + this.helper.L11) * z + this.helper.L12;
        A.data[4] = ((this.helper.M00 * z + this.helper.M01) * z + this.helper.M02) * z + this.helper.M03;
        A.data[5] = ((this.helper.M04 * z + this.helper.M05) * z + this.helper.M06) * z + this.helper.M07;
        Y.data[2] = (((this.helper.M08 * z + this.helper.M09) * z + this.helper.M10) * z + this.helper.M11) * z + this.helper.M12;
        CommonOps.scale((double)-1.0, (D1Matrix64F)Y);
        DenseMatrix64F x = new DenseMatrix64F(2, 1);
        CommonOps.solve((DenseMatrix64F)A, (DenseMatrix64F)Y, (DenseMatrix64F)x);
        this.x = x.get(0, 0);
        this.y = x.get(1, 0);
    }
}

