/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.h.AdjustHomographyMatrix;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.SingularOps;
import org.ejml.ops.SpecializedOps;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class HomographyLinear4 {
    protected DenseMatrix64F A = new DenseMatrix64F(1, 9);
    protected SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)0, (int)0, (boolean)true, (boolean)true, (boolean)false);
    protected DenseMatrix64F N1 = new DenseMatrix64F(3, 3);
    protected DenseMatrix64F N2 = new DenseMatrix64F(3, 3);
    private AdjustHomographyMatrix adjust = new AdjustHomographyMatrix();
    boolean normalize;

    public HomographyLinear4(boolean normalizeInput) {
        this.normalize = normalizeInput;
    }

    public boolean process(List<AssociatedPair> points, DenseMatrix64F foundH) {
        if (points.size() < 4) {
            throw new IllegalArgumentException("Must be at least 4 points.");
        }
        if (this.normalize) {
            LowLevelMultiViewOps.computeNormalization(points, this.N1, this.N2);
            this.createANormalized(points, this.A);
        } else {
            this.createA(points, this.A);
        }
        if (this.computeH(this.A, foundH)) {
            return false;
        }
        if (this.normalize) {
            this.undoNormalizationH(foundH, this.N1, this.N2);
        }
        this.adjust.adjust(foundH, points.get(0));
        return true;
    }

    protected boolean computeH(DenseMatrix64F A, DenseMatrix64F H) {
        if (!this.svd.decompose((Matrix64F)A)) {
            return true;
        }
        if (A.numRows > 8) {
            SingularOps.nullVector(this.svd, (boolean)true, (DenseMatrix64F)H);
        } else {
            DenseMatrix64F V = (DenseMatrix64F)this.svd.getV(null, false);
            SpecializedOps.subvector((RowD1Matrix64F)V, (int)0, (int)8, (int)V.numCols, (boolean)false, (int)0, (RowD1Matrix64F)H);
        }
        return false;
    }

    protected void undoNormalizationH(DenseMatrix64F M, DenseMatrix64F N1, DenseMatrix64F N2) {
        SimpleMatrix a = SimpleMatrix.wrap((DenseMatrix64F)M);
        SimpleMatrix b = SimpleMatrix.wrap((DenseMatrix64F)N1);
        SimpleMatrix c = SimpleMatrix.wrap((DenseMatrix64F)N2);
        SimpleMatrix result = (SimpleMatrix)((SimpleMatrix)((SimpleMatrix)c.invert()).mult((SimpleBase)a)).mult((SimpleBase)b);
        M.set((D1Matrix64F)result.getMatrix());
    }

    protected void createANormalized(List<AssociatedPair> points, DenseMatrix64F A) {
        A.reshape(points.size() * 2, 9, false);
        A.zero();
        Point2D_F64 f_norm = new Point2D_F64();
        Point2D_F64 s_norm = new Point2D_F64();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            AssociatedPair p = points.get(i);
            Point2D_F64 f = p.p1;
            Point2D_F64 s = p.p2;
            LowLevelMultiViewOps.applyPixelNormalization(this.N1, f, f_norm);
            LowLevelMultiViewOps.applyPixelNormalization(this.N2, s, s_norm);
            A.set(i * 2, 3, -f_norm.x);
            A.set(i * 2, 4, -f_norm.y);
            A.set(i * 2, 5, -1.0);
            A.set(i * 2, 6, s_norm.y * f_norm.x);
            A.set(i * 2, 7, s_norm.y * f_norm.y);
            A.set(i * 2, 8, s_norm.y);
            A.set(i * 2 + 1, 0, f_norm.x);
            A.set(i * 2 + 1, 1, f_norm.y);
            A.set(i * 2 + 1, 2, 1.0);
            A.set(i * 2 + 1, 6, -s_norm.x * f_norm.x);
            A.set(i * 2 + 1, 7, -s_norm.x * f_norm.y);
            A.set(i * 2 + 1, 8, -s_norm.x);
        }
    }

    protected void createA(List<AssociatedPair> points, DenseMatrix64F A) {
        A.reshape(points.size() * 2, 9, false);
        A.zero();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            AssociatedPair p = points.get(i);
            Point2D_F64 f = p.p1;
            Point2D_F64 s = p.p2;
            A.set(i * 2, 3, -f.x);
            A.set(i * 2, 4, -f.y);
            A.set(i * 2, 5, -1.0);
            A.set(i * 2, 6, s.y * f.x);
            A.set(i * 2, 7, s.y * f.y);
            A.set(i * 2, 8, s.y);
            A.set(i * 2 + 1, 0, f.x);
            A.set(i * 2 + 1, 1, f.y);
            A.set(i * 2 + 1, 2, 1.0);
            A.set(i * 2 + 1, 6, -s.x * f.x);
            A.set(i * 2 + 1, 7, -s.x * f.y);
            A.set(i * 2 + 1, 8, -s.x);
        }
    }
}

