/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.tracker.ExtractTrackDescription;
import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.geo.TriangulateTwoViewsCalibrated;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.feature.associate.StereoConsistencyCheck;
import boofcv.struct.FastQueue;
import boofcv.struct.GrowQueue_I32;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelMatcher;

public class VisOdomDualTrackPnP<T extends ImageSingleBand, Desc extends TupleDesc> {
    private int thresholdAdd;
    private int thresholdRetire;
    private ModelMatcher<Se3_F64, Stereo2D3D> matcher;
    private ModelFitter<Se3_F64, Stereo2D3D> modelRefiner;
    private PointTracker<T> trackerLeft;
    private PointTracker<T> trackerRight;
    private ExtractTrackDescription<Desc> extractLeft;
    private ExtractTrackDescription<Desc> extractRight;
    private FastQueue<Point2D_F64> pointsLeft = new FastQueue<Point2D_F64>(Point2D_F64.class, false);
    private FastQueue<Point2D_F64> pointsRight = new FastQueue<Point2D_F64>(Point2D_F64.class, false);
    private FastQueue<Desc> descLeft;
    private FastQueue<Desc> descRight;
    private AssociateDescription2D<Desc> assocL2R;
    private TriangulateTwoViewsCalibrated triangulate;
    private PointTransform_F64 leftImageToNorm;
    private PointTransform_F64 rightImageToNorm;
    private StereoConsistencyCheck stereoCheck;
    private Se3_F64 leftToRight = new Se3_F64();
    private List<PointTrack> candidates = new ArrayList<PointTrack>();
    private Se3_F64 keyToWorld = new Se3_F64();
    private Se3_F64 currToKey = new Se3_F64();
    private Se3_F64 currToWorld = new Se3_F64();
    private int tick;
    private boolean first = true;

    public VisOdomDualTrackPnP(int thresholdAdd, int thresholdRetire, double epilolarTol, PointTracker<T> trackerLeft, PointTracker<T> trackerRight, AssociateDescription2D<Desc> assocL2R, TriangulateTwoViewsCalibrated triangulate, ModelMatcher<Se3_F64, Stereo2D3D> matcher, ModelFitter<Se3_F64, Stereo2D3D> modelRefiner) {
        if (!assocL2R.uniqueSource() || !assocL2R.uniqueDestination()) {
            throw new IllegalArgumentException("Both unique source and destination must be ensure by association");
        }
        try {
            this.extractLeft = (ExtractTrackDescription)((Object)trackerLeft);
            this.extractRight = (ExtractTrackDescription)((Object)trackerRight);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Both trackers must implement TrackDescription");
        }
        this.thresholdAdd = thresholdAdd;
        this.thresholdRetire = thresholdRetire;
        this.trackerLeft = trackerLeft;
        this.trackerRight = trackerRight;
        this.assocL2R = assocL2R;
        this.triangulate = triangulate;
        this.matcher = matcher;
        this.modelRefiner = modelRefiner;
        this.descLeft = new FastQueue(this.extractLeft.getDescriptionType(), false);
        this.descRight = new FastQueue(this.extractRight.getDescriptionType(), false);
        this.stereoCheck = new StereoConsistencyCheck(epilolarTol, epilolarTol);
    }

    public void setCalibration(StereoParameters param) {
        param.rightToLeft.invert(this.leftToRight);
        this.leftImageToNorm = LensDistortionOps.transformRadialToNorm_F64(param.left);
        this.rightImageToNorm = LensDistortionOps.transformRadialToNorm_F64(param.right);
        this.stereoCheck.setCalibration(param);
    }

    public void reset() {
        this.trackerLeft.reset();
        this.trackerRight.reset();
        this.keyToWorld.reset();
        this.currToKey.reset();
        this.first = true;
        this.tick = 0;
    }

    public boolean process(T left, T right) {
        ++this.tick;
        this.trackerLeft.process(left);
        this.trackerRight.process(right);
        if (this.first) {
            this.addNewTracks();
            this.first = false;
        } else {
            this.mutualTrackDrop();
            this.selectCandidateTracks();
            if (!this.estimateMotion()) {
                return false;
            }
            this.dropUnusedTracks();
            int N = this.matcher.getMatchSet().size();
            if (this.modelRefiner != null) {
                this.refineMotionEstimate();
            }
            if (this.thresholdAdd <= 0 || N < this.thresholdAdd) {
                this.changePoseToReference();
                this.addNewTracks();
            }
        }
        return true;
    }

    private void refineMotionEstimate() {
        Se3_F64 found;
        ArrayList<Stereo2D3D> data = new ArrayList<Stereo2D3D>();
        int N = this.matcher.getMatchSet().size();
        for (int i = 0; i < N; ++i) {
            int index = this.matcher.getInputIndex(i);
            PointTrack l = this.candidates.get(index);
            LeftTrackInfo info = (LeftTrackInfo)l.getCookie();
            PointTrack r = info.right;
            Stereo2D3D stereo = info.location;
            this.leftImageToNorm.compute(l.x, l.y, info.location.leftObs);
            this.rightImageToNorm.compute(r.x, r.y, info.location.rightObs);
            data.add(stereo);
        }
        Se3_F64 keyToCurr = this.currToKey.invert(null);
        if (this.modelRefiner.fitModel(data, (Object)keyToCurr, (Object)(found = new Se3_F64()))) {
            found.invert(this.currToKey);
        }
    }

    private boolean estimateMotion() {
        ArrayList<Stereo2D3D> data = new ArrayList<Stereo2D3D>();
        for (PointTrack l : this.candidates) {
            LeftTrackInfo info = (LeftTrackInfo)l.getCookie();
            PointTrack r = info.right;
            Stereo2D3D stereo = info.location;
            this.leftImageToNorm.compute(l.x, l.y, info.location.leftObs);
            this.rightImageToNorm.compute(r.x, r.y, info.location.rightObs);
            data.add(stereo);
        }
        if (!this.matcher.process(data)) {
            return false;
        }
        Se3_F64 keyToCurr = (Se3_F64)this.matcher.getModel();
        keyToCurr.invert(this.currToKey);
        int N = this.matcher.getMatchSet().size();
        for (int i = 0; i < N; ++i) {
            int index = this.matcher.getInputIndex(i);
            LeftTrackInfo info = (LeftTrackInfo)this.candidates.get(index).getCookie();
            info.lastInlier = this.tick;
        }
        return true;
    }

    private void mutualTrackDrop() {
        Object info;
        for (PointTrack t : this.trackerLeft.getDroppedTracks(null)) {
            info = (LeftTrackInfo)t.getCookie();
            this.trackerRight.dropTrack(((LeftTrackInfo)info).right);
        }
        for (PointTrack t : this.trackerRight.getDroppedTracks(null)) {
            info = (RightTrackInfo)t.getCookie();
            this.trackerLeft.dropTrack(((RightTrackInfo)info).left);
        }
    }

    private void selectCandidateTracks() {
        List<PointTrack> activeRight = this.trackerRight.getActiveTracks(null);
        for (PointTrack t : activeRight) {
            RightTrackInfo info = (RightTrackInfo)t.getCookie();
            info.lastActiveList = this.tick;
        }
        int mutualActive = 0;
        List<PointTrack> activeLeft = this.trackerLeft.getActiveTracks(null);
        this.candidates.clear();
        for (PointTrack left : activeLeft) {
            LeftTrackInfo info = (LeftTrackInfo)left.getCookie();
            RightTrackInfo infoRight = (RightTrackInfo)info.right.getCookie();
            if (infoRight.lastActiveList != this.tick) continue;
            if (this.stereoCheck.checkPixel(left, info.right)) {
                info.lastConsistent = this.tick;
                this.candidates.add(left);
            }
            ++mutualActive;
        }
    }

    private int dropUnusedTracks() {
        List<PointTrack> all = this.trackerLeft.getAllTracks(null);
        int num = 0;
        for (PointTrack t : all) {
            LeftTrackInfo info = (LeftTrackInfo)t.getCookie();
            if (this.tick - info.lastInlier <= this.thresholdRetire) continue;
            if (!this.trackerLeft.dropTrack(t)) {
                throw new IllegalArgumentException("failed to drop unused left track");
            }
            if (!this.trackerRight.dropTrack(info.right)) {
                throw new IllegalArgumentException("failed to drop unused right track");
            }
            ++num;
        }
        return num;
    }

    private void changePoseToReference() {
        Se3_F64 keyToCurr = this.currToKey.invert(null);
        List<PointTrack> all = this.trackerLeft.getAllTracks(null);
        for (PointTrack t : all) {
            LeftTrackInfo p = (LeftTrackInfo)t.getCookie();
            SePointOps_F64.transform((Se3_F64)keyToCurr, (Point3D_F64)p.location.location, (Point3D_F64)p.location.location);
        }
        this.concatMotion();
    }

    private void addNewTracks() {
        this.trackerLeft.spawnTracks();
        this.trackerRight.spawnTracks();
        List<PointTrack> newLeft = this.trackerLeft.getNewTracks(null);
        List<PointTrack> newRight = this.trackerRight.getNewTracks(null);
        this.addNewToList(this.trackerLeft, this.extractLeft, newLeft, this.pointsLeft, this.descLeft);
        this.addNewToList(this.trackerRight, this.extractRight, newRight, this.pointsRight, this.descRight);
        this.assocL2R.setSource(this.pointsLeft, this.descLeft);
        this.assocL2R.setDestination(this.pointsRight, this.descRight);
        this.assocL2R.associate();
        FastQueue<AssociatedIndex> matches = this.assocL2R.getMatches();
        Point3D_F64 cameraP3 = new Point3D_F64();
        for (int i = 0; i < matches.size; ++i) {
            RightTrackInfo infoRight;
            AssociatedIndex m = matches.get(i);
            PointTrack trackL = newLeft.get(m.src);
            PointTrack trackR = newRight.get(m.dst);
            LeftTrackInfo infoLeft = (LeftTrackInfo)trackL.getCookie();
            if (infoLeft == null) {
                infoLeft = new LeftTrackInfo();
                trackL.cookie = infoLeft;
            }
            if ((infoRight = (RightTrackInfo)trackR.getCookie()) == null) {
                infoRight = new RightTrackInfo();
                trackR.cookie = infoRight;
            }
            Stereo2D3D p2d3d = infoLeft.location;
            this.leftImageToNorm.compute(trackL.x, trackL.y, p2d3d.leftObs);
            this.rightImageToNorm.compute(trackR.x, trackR.y, p2d3d.rightObs);
            if (!this.triangulate.triangulate(p2d3d.leftObs, p2d3d.rightObs, this.leftToRight, cameraP3)) {
                this.trackerLeft.dropTrack(trackL);
                throw new RuntimeException("This special case needs to be handled!");
            }
            SePointOps_F64.transform((Se3_F64)this.currToKey, (Point3D_F64)cameraP3, (Point3D_F64)p2d3d.location);
            infoLeft.right = trackR;
            infoLeft.lastConsistent = infoLeft.lastInlier = this.tick;
            infoRight.left = trackL;
        }
        GrowQueue_I32 unassignedRight = this.assocL2R.getUnassociatedDestination();
        for (int i = 0; i < unassignedRight.size; ++i) {
            int index = unassignedRight.get(i);
            this.trackerRight.dropTrack(newRight.get(index));
        }
        GrowQueue_I32 unassignedLeft = this.assocL2R.getUnassociatedSource();
        for (int i = 0; i < unassignedLeft.size; ++i) {
            int index = unassignedLeft.get(i);
            this.trackerLeft.dropTrack(newLeft.get(index));
        }
    }

    private void addNewToList(PointTracker<T> tracker, ExtractTrackDescription<Desc> extract, List<PointTrack> tracks, FastQueue<Point2D_F64> points, FastQueue<Desc> descs) {
        points.reset();
        descs.reset();
        for (int i = 0; i < tracks.size(); ++i) {
            PointTrack t = tracks.get(i);
            Desc desc = extract.extractDescription(t);
            points.add(t);
            descs.add(desc);
        }
    }

    private void concatMotion() {
        Se3_F64 temp = new Se3_F64();
        this.currToKey.concat(this.keyToWorld, temp);
        this.keyToWorld.set(temp);
        this.currToKey.reset();
    }

    public Se3_F64 getCurrToWorld() {
        this.currToKey.concat(this.keyToWorld, this.currToWorld);
        return this.currToWorld;
    }

    public int getTick() {
        return this.tick;
    }

    public List<PointTrack> getCandidates() {
        return this.candidates;
    }

    public ModelMatcher<Se3_F64, Stereo2D3D> getMatcher() {
        return this.matcher;
    }

    public static class RightTrackInfo {
        public int lastActiveList;
        public PointTrack left;
    }

    public static class LeftTrackInfo {
        public Stereo2D3D location = new Stereo2D3D();
        public int lastConsistent;
        public int lastInlier;
        public PointTrack right;
    }
}

