/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.combined;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.alg.tracker.combined.CombinedTrack;
import boofcv.alg.tracker.combined.PyramidKltForCombined;
import boofcv.struct.FastQueue;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.PyramidDiscrete;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class CombinedTrackerScalePoint<I extends ImageSingleBand, D extends ImageSingleBand, TD extends TupleDesc> {
    private I input;
    protected PyramidKltForCombined<I, D> trackerKlt;
    protected DetectDescribePoint<I, TD> detector;
    protected AssociateDescription<TD> associate;
    protected List<CombinedTrack<TD>> tracksPureKlt = new ArrayList<CombinedTrack<TD>>();
    protected List<CombinedTrack<TD>> tracksReactivated = new ArrayList<CombinedTrack<TD>>();
    protected List<CombinedTrack<TD>> tracksDormant = new ArrayList<CombinedTrack<TD>>();
    protected List<CombinedTrack<TD>> tracksSpawned = new ArrayList<CombinedTrack<TD>>();
    protected Stack<CombinedTrack<TD>> tracksUnused = new Stack();
    protected FastQueue<TD> detectedDesc;
    protected FastQueue<TD> knownDesc;
    protected long totalTracks = 0L;
    private boolean[] associated = new boolean[1];

    public CombinedTrackerScalePoint(PyramidKltForCombined<I, D> trackerKlt, DetectDescribePoint<I, TD> detector, AssociateDescription<TD> associate) {
        this.trackerKlt = trackerKlt;
        this.detector = detector;
        this.detectedDesc = new FastQueue(10, detector.getDescriptionType(), false);
        this.knownDesc = new FastQueue(10, detector.getDescriptionType(), false);
        this.associate = associate;
    }

    protected CombinedTrackerScalePoint() {
    }

    public void reset() {
        this.dropAllTracks();
        this.totalTracks = 0L;
    }

    public void updateTracks(I input, PyramidDiscrete<I> pyramid, D[] derivX, D[] derivY) {
        this.tracksSpawned.clear();
        this.input = input;
        this.trackerKlt.setInputs(pyramid, (ImageSingleBand[])derivX, (ImageSingleBand[])derivY);
        this.trackUsingKlt(this.tracksPureKlt);
        this.trackUsingKlt(this.tracksReactivated);
    }

    private void trackUsingKlt(List<CombinedTrack<TD>> tracks) {
        int i = 0;
        while (i < tracks.size()) {
            CombinedTrack<TD> track = tracks.get(i);
            if (!this.trackerKlt.performTracking(track.track)) {
                tracks.remove(i);
                this.tracksDormant.add(track);
                continue;
            }
            track.set(track.track.x, track.track.y);
            ++i;
        }
    }

    public void spawnTracksFromDetected() {
        FastQueue<AssociatedIndex> matches = this.associate.getMatches();
        int N = this.detector.getNumberOfFeatures();
        for (int i = 0; i < N; ++i) {
            this.associated[i] = false;
        }
        for (AssociatedIndex i : matches.toList()) {
            this.associated[i.dst] = true;
        }
        for (int i = 0; i < N; ++i) {
            CombinedTrack track;
            if (this.associated[i]) continue;
            Point2D_F64 p = this.detector.getLocation(i);
            TupleDesc d = (TupleDesc)this.detectedDesc.get(i);
            if (this.tracksUnused.size() > 0) {
                track = this.tracksUnused.pop();
            } else {
                track = new CombinedTrack();
                track.desc = this.detector.createDescription();
                track.track = this.trackerKlt.createNewTrack();
            }
            this.trackerKlt.setDescription((float)p.x, (float)p.y, track.track);
            ++this.totalTracks;
            track.featureId = track.featureId;
            track.desc.setTo((TupleDesc)d);
            track.set(p);
            this.tracksPureKlt.add(track);
            this.tracksSpawned.add(track);
        }
    }

    private void associateToDetected(List<CombinedTrack<TD>> known) {
        this.detectedDesc.reset();
        this.knownDesc.reset();
        int N = this.detector.getNumberOfFeatures();
        for (int i = 0; i < N; ++i) {
            this.detectedDesc.add(this.detector.getDescription(i));
        }
        for (CombinedTrack<TD> t : known) {
            this.knownDesc.add(t.desc);
        }
        this.associate.setSource(this.knownDesc);
        this.associate.setDestination(this.detectedDesc);
        this.associate.associate();
        N = Math.max(known.size(), this.detector.getNumberOfFeatures());
        if (this.associated.length < N) {
            this.associated = new boolean[N];
        }
    }

    public void associateAllToDetected() {
        ArrayList<CombinedTrack<TD>> all = new ArrayList<CombinedTrack<TD>>();
        all.addAll(this.tracksReactivated);
        all.addAll(this.tracksDormant);
        all.addAll(this.tracksPureKlt);
        int numTainted = this.tracksReactivated.size() + this.tracksDormant.size();
        this.tracksReactivated.clear();
        this.tracksDormant.clear();
        this.detector.detect(this.input);
        this.associateToDetected(all);
        FastQueue<AssociatedIndex> matches = this.associate.getMatches();
        for (int i = 0; i < numTainted; ++i) {
            this.associated[i] = false;
        }
        for (AssociatedIndex a : matches.toList()) {
            if (a.src >= numTainted) continue;
            CombinedTrack t = (CombinedTrack)((Object)all.get(a.src));
            t.set(this.detector.getLocation(a.dst));
            this.trackerKlt.setDescription((float)t.x, (float)t.y, t.track);
            this.tracksReactivated.add(t);
            this.associated[a.src] = true;
        }
        for (int i = 0; i < numTainted; ++i) {
            if (this.associated[i]) continue;
            this.tracksDormant.add((CombinedTrack<TD>)((Object)all.get(i)));
        }
    }

    public boolean dropTrack(CombinedTrack<TD> track) {
        if (!(this.tracksPureKlt.remove(track) || this.tracksReactivated.remove(track) || this.tracksDormant.remove(track))) {
            return false;
        }
        this.tracksUnused.add(track);
        return true;
    }

    public List<CombinedTrack<TD>> getSpawned() {
        return this.tracksSpawned;
    }

    public List<CombinedTrack<TD>> getPureKlt() {
        return this.tracksPureKlt;
    }

    public List<CombinedTrack<TD>> getReactivated() {
        return this.tracksReactivated;
    }

    public List<CombinedTrack<TD>> getDormant() {
        return this.tracksDormant;
    }

    public PyramidKltForCombined<I, D> getTrackerKlt() {
        return this.trackerKlt;
    }

    public DetectDescribePoint<I, TD> getDetector() {
        return this.detector;
    }

    public void dropAllTracks() {
        this.tracksUnused.addAll(this.tracksDormant);
        this.tracksUnused.addAll(this.tracksPureKlt);
        this.tracksUnused.addAll(this.tracksReactivated);
        this.tracksSpawned.clear();
        this.tracksPureKlt.clear();
        this.tracksReactivated.clear();
        this.tracksSpawned.clear();
        this.tracksDormant.clear();
    }
}

