/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.klt;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.klt.KltConfig;
import boofcv.alg.tracker.klt.KltFeature;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;

public class KltTracker<InputImage extends ImageSingleBand, DerivativeImage extends ImageSingleBand> {
    protected InputImage image;
    protected DerivativeImage derivX;
    protected DerivativeImage derivY;
    protected InterpolateRectangle<InputImage> interpInput;
    protected InterpolateRectangle<DerivativeImage> interpDeriv;
    protected KltConfig config;
    protected float Gxx;
    protected float Gyy;
    protected float Gxy;
    protected float Ex;
    protected float Ey;
    protected int widthFeature;
    protected int lengthFeature;
    protected ImageFloat32 descFeature = new ImageFloat32(1, 1);
    float allowedLeft;
    float allowedRight;
    float allowedTop;
    float allowedBottom;

    public KltTracker(InterpolateRectangle<InputImage> interpInput, InterpolateRectangle<DerivativeImage> interpDeriv, KltConfig config) {
        this.interpInput = interpInput;
        this.interpDeriv = interpDeriv;
        this.config = config;
    }

    public void setImage(InputImage image, DerivativeImage derivX, DerivativeImage derivY) {
        if (derivX != null && derivY != null) {
            InputSanityCheck.checkSameShape(image, derivX, derivY);
        }
        this.image = image;
        this.interpInput.setImage(image);
        this.derivX = derivX;
        this.derivY = derivY;
    }

    public boolean setDescription(KltFeature feature) {
        if (this.derivX == null || this.derivY == null) {
            throw new IllegalArgumentException("Image derivatives must be set");
        }
        this.setAllowedBounds(feature);
        if (!this.isFullyInside(feature.x, feature.y)) {
            return false;
        }
        this.internalSetDescription(feature);
        return true;
    }

    private void internalSetDescription(KltFeature feature) {
        int regionWidth = feature.radius * 2 + 1;
        int size = regionWidth * regionWidth;
        float tl_x = feature.x - (float)feature.radius;
        float tl_y = feature.y - (float)feature.radius;
        this.interpInput.setImage(this.image);
        this.interpInput.region(tl_x, tl_y, feature.desc);
        this.interpDeriv.setImage(this.derivX);
        this.interpDeriv.region(tl_x, tl_y, feature.derivX);
        this.interpDeriv.setImage(this.derivY);
        this.interpDeriv.region(tl_x, tl_y, feature.derivY);
        float Gxx = 0.0f;
        float Gyy = 0.0f;
        float Gxy = 0.0f;
        for (int i = 0; i < size; ++i) {
            float dX = feature.derivX.data[i];
            float dY = feature.derivY.data[i];
            Gxx += dX * dX;
            Gyy += dY * dY;
            Gxy += dX * dY;
        }
        feature.Gxx = Gxx;
        feature.Gyy = Gyy;
        feature.Gxy = Gxy;
    }

    public KltTrackFault track(KltFeature feature) {
        float origX = feature.x;
        float origY = feature.y;
        this.setAllowedBounds(feature);
        if (!this.isFullyInside(feature.x, feature.y)) {
            return KltTrackFault.OUT_OF_BOUNDS;
        }
        this.Gxx = feature.Gxx;
        this.Gyy = feature.Gyy;
        this.Gxy = feature.Gxy;
        float det = this.Gxx * this.Gyy - this.Gxy * this.Gxy;
        if (det < this.config.minDeterminant) {
            return KltTrackFault.FAILED;
        }
        this.widthFeature = feature.radius * 2 + 1;
        this.lengthFeature = this.widthFeature * this.widthFeature;
        if (this.descFeature.data.length < this.lengthFeature) {
            this.descFeature.reshape(this.widthFeature, this.widthFeature);
        }
        for (int iter = 0; iter < this.config.maxIterations; ++iter) {
            this.computeE(feature, feature.x, feature.y);
            float dx = (this.Gyy * this.Ex - this.Gxy * this.Ey) / det;
            float dy = (this.Gxx * this.Ey - this.Gxy * this.Ex) / det;
            feature.x += dx;
            feature.y += dy;
            if (!this.isFullyInside(feature.x, feature.y)) {
                return KltTrackFault.OUT_OF_BOUNDS;
            }
            if (Math.abs(feature.x - origX) > (float)this.widthFeature || Math.abs(feature.y - origY) > (float)this.widthFeature) {
                return KltTrackFault.DRIFTED;
            }
            if (Math.abs(dx) < this.config.minPositionDelta && Math.abs(dy) < this.config.minPositionDelta) break;
        }
        if (this.computeError(feature) > this.config.maxPerPixelError) {
            return KltTrackFault.LARGE_ERROR;
        }
        return KltTrackFault.SUCCESS;
    }

    private void setAllowedBounds(KltFeature feature) {
        this.allowedLeft = feature.radius + this.config.forbiddenBorder;
        this.allowedTop = feature.radius + this.config.forbiddenBorder;
        this.allowedRight = ((ImageSingleBand)this.image).width - (feature.radius + this.config.forbiddenBorder);
        this.allowedBottom = ((ImageSingleBand)this.image).height - (feature.radius + this.config.forbiddenBorder);
    }

    private float computeError(KltFeature feature) {
        float error = 0.0f;
        for (int i = 0; i < this.lengthFeature; ++i) {
            error += Math.abs(feature.desc.data[i] - this.descFeature.data[i]);
        }
        return error / (float)this.lengthFeature;
    }

    private void computeE(KltFeature feature, float x, float y) {
        this.interpInput.region(x - (float)feature.radius, y - (float)feature.radius, this.descFeature);
        this.Ex = 0.0f;
        this.Ey = 0.0f;
        for (int i = 0; i < this.lengthFeature; ++i) {
            float d = feature.desc.data[i] - this.descFeature.data[i];
            this.Ex += d * feature.derivX.data[i];
            this.Ey += d * feature.derivY.data[i];
        }
    }

    public boolean isFullyInside(float x, float y) {
        if (x < this.allowedLeft || x >= this.allowedRight) {
            return false;
        }
        return !(y < this.allowedTop) && !(y >= this.allowedBottom);
    }

    public KltConfig getConfig() {
        return this.config;
    }
}

