/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii;

import boofcv.alg.transform.ii.IntegralImageOps;
import boofcv.alg.transform.ii.IntegralKernel;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public class GIntegralImageOps {
    public static <I extends ImageSingleBand, II extends ImageSingleBand> Class<II> getIntegralType(Class<I> inputType) {
        if (inputType == ImageFloat32.class) {
            return ImageFloat32.class;
        }
        if (inputType == ImageUInt8.class) {
            return ImageSInt32.class;
        }
        if (inputType == ImageSInt32.class) {
            return ImageSInt32.class;
        }
        throw new IllegalArgumentException("Unknown input image type: " + inputType.getSimpleName());
    }

    public static <I extends ImageSingleBand, T extends ImageSingleBand> T transform(I input, T transformed) {
        if (input instanceof ImageFloat32) {
            return (T)IntegralImageOps.transform((ImageFloat32)input, (ImageFloat32)transformed);
        }
        if (input instanceof ImageUInt8) {
            return (T)IntegralImageOps.transform((ImageUInt8)input, (ImageSInt32)transformed);
        }
        if (input instanceof ImageSInt32) {
            return (T)IntegralImageOps.transform((ImageSInt32)input, (ImageSInt32)transformed);
        }
        throw new IllegalArgumentException("Unknown input type");
    }

    public static <T extends ImageSingleBand> T convolve(T integral, IntegralKernel kernel, T output) {
        if (integral instanceof ImageFloat32) {
            return (T)IntegralImageOps.convolve((ImageFloat32)integral, kernel, (ImageFloat32)output);
        }
        if (integral instanceof ImageSInt32) {
            return (T)IntegralImageOps.convolve((ImageSInt32)integral, kernel, (ImageSInt32)output);
        }
        throw new IllegalArgumentException("Unknown input type");
    }

    public static <T extends ImageSingleBand> T convolveBorder(T integral, IntegralKernel kernel, T output, int borderX, int borderY) {
        if (integral instanceof ImageFloat32) {
            return (T)IntegralImageOps.convolveBorder((ImageFloat32)integral, kernel, (ImageFloat32)output, borderX, borderY);
        }
        if (integral instanceof ImageSInt32) {
            return (T)IntegralImageOps.convolveBorder((ImageSInt32)integral, kernel, (ImageSInt32)output, borderX, borderY);
        }
        throw new IllegalArgumentException("Unknown input type");
    }

    public static <T extends ImageSingleBand> double convolveSparse(T integral, IntegralKernel kernel, int x, int y) {
        if (integral instanceof ImageFloat32) {
            return IntegralImageOps.convolveSparse((ImageFloat32)integral, kernel, x, y);
        }
        if (integral instanceof ImageSInt32) {
            return IntegralImageOps.convolveSparse((ImageSInt32)integral, kernel, x, y);
        }
        throw new IllegalArgumentException("Unknown input type");
    }
}

