/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.impl.DistortSupport;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.PyramidFloat;

public class PyramidFloatScale<T extends ImageSingleBand>
extends PyramidFloat<T> {
    protected InterpolatePixel<T> interpolate;

    public PyramidFloatScale(InterpolatePixel<T> interpolate, double[] scaleFactors, Class<T> imageType) {
        super(imageType, scaleFactors);
        this.interpolate = interpolate;
    }

    @Override
    public void process(T input) {
        super.initialize(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        if (this.isSaveOriginalReference()) {
            throw new IllegalArgumentException("The original reference cannot be saved");
        }
        for (int i = 0; i < this.scale.length; ++i) {
            T prev = i == 0 ? input : this.getLayer(i - 1);
            ImageBase layer = this.getLayer(i);
            PixelTransformAffine_F32 model = DistortSupport.transformScale(layer, prev);
            DistortImageOps.distortSingle(prev, layer, (PixelTransform_F32)model, null, this.interpolate);
        }
    }

    @Override
    public double getSampleOffset(int layer) {
        return 0.0;
    }

    @Override
    public double getSigma(int layer) {
        return 0.0;
    }
}

