/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.wavelet;

import boofcv.core.image.border.BorderIndex1D;
import boofcv.core.image.border.BorderIndex1D_Reflect;
import boofcv.core.image.border.BorderIndex1D_Wrap;
import boofcv.core.image.border.BorderType;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.wavelet.WlBorderCoef;
import boofcv.struct.wavelet.WlCoef;

public class UtilWavelet {
    public static void checkShape(ImageSingleBand original, ImageSingleBand transformed) {
        if (transformed.width % 2 == 1 || transformed.height % 2 == 1) {
            throw new IllegalArgumentException("Image containing the wavelet transform must have an even width and height.");
        }
        int w = original.width + original.width % 2;
        int h = original.height + original.height % 2;
        if (transformed.width < w || transformed.height < h) {
            throw new IllegalArgumentException("Transformed image must be larger than the original image. (" + w + "," + h + ") vs (" + transformed.width + "," + transformed.height + ")");
        }
    }

    public static void checkShape(WlCoef desc, ImageSingleBand original, ImageSingleBand transformed, int level) {
        ImageDimension tranDim = UtilWavelet.transformDimension(original, level);
        if (transformed.width != tranDim.width || transformed.height != tranDim.height) {
            throw new IllegalArgumentException("Image containing the wavelet transform must be " + tranDim.width + " x " + tranDim.height);
        }
        if (original.width < desc.getScalingLength() || original.height < desc.getScalingLength()) {
            throw new IllegalArgumentException("Original image's width and height must be large enough the number of scaling coefficients.");
        }
        if (original.width < desc.getWaveletLength() || original.height < desc.getWaveletLength()) {
            throw new IllegalArgumentException("Original image's width and height must be large enough the number of wavelet coefficients.");
        }
    }

    public static int computeScale(int level) {
        if (level <= 1) {
            return 1;
        }
        return (int)Math.pow(2.0, level - 1);
    }

    public static int computeDiv(int level) {
        if (level <= 1) {
            return 2;
        }
        return (int)Math.pow(2.0, level - 1);
    }

    public static ImageDimension transformDimension(ImageSingleBand orig, int level) {
        return UtilWavelet.transformDimension(orig.width, orig.height, level);
    }

    public static ImageDimension transformDimension(int width, int height, int level) {
        int div = UtilWavelet.computeDiv(level);
        int w = width % div;
        int h = height % div;
        return new ImageDimension(width += w > 0 ? div - w : 0, height += h > 0 ? div - h : 0);
    }

    public static double computeEnergy(float[] array) {
        double total = 0.0;
        for (int i = 0; i < array.length; ++i) {
            total += (double)(array[i] * array[i]);
        }
        return total;
    }

    public static double computeEnergy(int[] array, int denominator) {
        double total = 0.0;
        for (int i = 0; i < array.length; ++i) {
            total += (double)(array[i] * array[i]);
        }
        return total /= (double)(denominator * denominator);
    }

    public static double sumCoefficients(float[] array) {
        double total = 0.0;
        for (int i = 0; i < array.length; ++i) {
            total += (double)array[i];
        }
        return total;
    }

    public static int sumCoefficients(int[] array) {
        int total = 0;
        for (int i = 0; i < array.length; ++i) {
            total += array[i];
        }
        return total;
    }

    public static int borderForwardLower(WlCoef desc) {
        int ret = -Math.min(desc.offsetScaling, desc.offsetWavelet);
        return ret + ret % 2;
    }

    public static int borderForwardUpper(WlCoef desc, int dataLength) {
        int w = Math.max(desc.offsetScaling + desc.getScalingLength(), desc.offsetWavelet + desc.getWaveletLength());
        int a = dataLength % 2;
        return Math.max((w -= a) + w % 2 - 2, 0) + a;
    }

    public static int borderInverseLower(WlBorderCoef<?> desc, BorderIndex1D border) {
        Object ll;
        Object inner = desc.getInnerCoefficients();
        int borderSize = UtilWavelet.borderForwardLower(inner);
        Object lu = ll = borderSize > 0 ? inner : null;
        Object uu = inner;
        int indexLU = 0;
        if (desc.getLowerLength() > 0) {
            ll = desc.getBorderCoefficients(0);
            indexLU = desc.getLowerLength() * 2 - 2;
            lu = desc.getBorderCoefficients(indexLU);
        }
        if (desc.getUpperLength() > 0) {
            uu = desc.getBorderCoefficients(-2);
        }
        border.setLength(2000);
        borderSize = UtilWavelet.checkInverseLower(ll, 0, border, borderSize);
        borderSize = UtilWavelet.checkInverseLower(lu, indexLU, border, borderSize);
        borderSize = UtilWavelet.checkInverseLower(uu, 1998, border, borderSize);
        return borderSize;
    }

    public static int checkInverseLower(WlCoef coef, int index, BorderIndex1D border, int current) {
        if (coef == null) {
            return current;
        }
        int a = index + Math.max(coef.getScalingLength() + coef.offsetScaling, coef.getWaveletLength() + coef.offsetScaling);
        int b = index + Math.min(coef.offsetScaling, coef.offsetWavelet) - 1;
        a = border.getIndex(a);
        b = border.getIndex(b);
        if (a > 1000) {
            a = -1;
        }
        if (b > 1000) {
            b = -1;
        }
        a = Math.max(a, b);
        a += a % 2;
        return Math.max(a, current);
    }

    public static int borderInverseUpper(WlBorderCoef<?> desc, BorderIndex1D border, int dataLength) {
        Object uu;
        Object inner = desc.getInnerCoefficients();
        int borderSize = UtilWavelet.borderForwardUpper(inner, dataLength);
        Object ul = uu = (borderSize += borderSize % 2) > 0 ? inner : null;
        Object ll = inner;
        int indexUL = 1998;
        if (desc.getUpperLength() > 0) {
            uu = desc.getBorderCoefficients(-2);
            indexUL = 2000 - desc.getUpperLength() * 2;
            ul = desc.getBorderCoefficients(2000 - indexUL);
        }
        if (desc.getLowerLength() > 0) {
            ll = desc.getBorderCoefficients(0);
        }
        border.setLength(2000);
        borderSize = UtilWavelet.checkInverseUpper(uu, 2000 - borderSize, border, borderSize);
        borderSize = UtilWavelet.checkInverseUpper(ul, indexUL, border, borderSize);
        borderSize = UtilWavelet.checkInverseUpper(ll, 0, border, borderSize);
        return borderSize;
    }

    public static int checkInverseUpper(WlCoef coef, int index, BorderIndex1D border, int current) {
        if (coef == null) {
            return current;
        }
        int a = index + Math.max(coef.getScalingLength() + coef.offsetScaling, coef.getWaveletLength() + coef.offsetScaling) - 1;
        int b = index + Math.min(coef.offsetScaling, coef.offsetWavelet);
        a = border.getIndex(a);
        b = border.getIndex(b);
        if (a < 1000) {
            a = 10000;
        }
        if (b < 1000) {
            b = 10000;
        }
        a = 2000 - Math.min(a, b);
        a += a % 2;
        return Math.max(a, current);
    }

    public static int round(int top, int div2, int divisor) {
        if (top > 0) {
            return (top + div2) / divisor;
        }
        return (top - div2) / divisor;
    }

    public static BorderType convertToType(BorderIndex1D b) {
        if (b instanceof BorderIndex1D_Reflect) {
            return BorderType.REFLECT;
        }
        if (b instanceof BorderIndex1D_Wrap) {
            return BorderType.WRAP;
        }
        throw new RuntimeException("Unknown border type: " + b.getClass().getSimpleName());
    }

    public static void adjustForDisplay(ImageSingleBand transform, int numLevels, double valueRange) {
        if (transform instanceof ImageFloat32) {
            UtilWavelet.adjustForDisplay((ImageFloat32)transform, numLevels, (float)valueRange);
        } else {
            UtilWavelet.adjustForDisplay((ImageInteger)transform, numLevels, (int)valueRange);
        }
    }

    private static void adjustForDisplay(ImageFloat32 transform, int numLevels, float valueRange) {
        int minX = 0;
        int minY = 0;
        for (int div = (int)Math.pow(2.0, numLevels); div >= 1; div /= 2) {
            int x;
            int y;
            int maxX = transform.width / div;
            int maxY = transform.height / div;
            float max = 0.0f;
            for (y = 0; y < maxY; ++y) {
                for (x = 0; x < maxX; ++x) {
                    if (x < minX && y < minY) continue;
                    float val = Math.abs(transform.data[transform.getIndex(x, y)]);
                    max = Math.max(val, max);
                }
            }
            for (y = 0; y < maxY; ++y) {
                for (x = 0; x < maxX; ++x) {
                    if (x < minX && y < minY) continue;
                    int n = transform.getIndex(x, y);
                    transform.data[n] = transform.data[n] * (valueRange / max);
                }
            }
            minX = maxX;
            minY = maxY;
        }
    }

    private static void adjustForDisplay(ImageInteger transform, int numLevels, int valueRange) {
        int minX = 0;
        int minY = 0;
        for (int div = (int)Math.pow(2.0, numLevels); div >= 1; div /= 2) {
            int val;
            int x;
            int y;
            int maxX = transform.width / div;
            int maxY = transform.height / div;
            int max = 0;
            for (y = 0; y < maxX; ++y) {
                for (x = 0; x < maxY; ++x) {
                    if (x < minX && y < minY) continue;
                    val = Math.abs(transform.get(x, y));
                    max = Math.max(val, max);
                }
            }
            for (y = 0; y < maxX; ++y) {
                for (x = 0; x < maxY; ++x) {
                    if (x < minX && y < minY) continue;
                    val = transform.get(x, y);
                    transform.set(x, y, val * valueRange / max);
                }
            }
            minX = maxX;
            minY = maxY;
        }
    }
}

