/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.wavelet.impl;

import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.core.image.border.BorderIndex1D;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.wavelet.WlBorderCoef;
import boofcv.struct.wavelet.WlCoef;
import boofcv.struct.wavelet.WlCoef_F32;
import boofcv.struct.wavelet.WlCoef_I32;

public class ImplWaveletTransformBorder {
    public static void horizontal(BorderIndex1D border, WlCoef_F32 coefficients, ImageFloat32 input, ImageFloat32 output) {
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        float[] alpha = coefficients.scaling;
        float[] beta = coefficients.wavelet;
        border.setLength(input.width + input.width % 2);
        boolean isLarger = output.width > input.width;
        int width = input.width + input.width % 2;
        int height = input.height;
        int lowerBorder = UtilWavelet.borderForwardLower(coefficients);
        int upperBorder = input.width - UtilWavelet.borderForwardUpper(coefficients, input.width);
        for (int y = 0; y < height; ++y) {
            int outX;
            int xx;
            int i;
            float wavelet;
            float scale;
            int x;
            for (x = 0; x < lowerBorder; x += 2) {
                scale = 0.0f;
                wavelet = 0.0f;
                for (i = 0; i < alpha.length; ++i) {
                    xx = border.getIndex(x + i + offsetA);
                    if (isLarger && xx >= input.width) continue;
                    scale += input.get(xx, y) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    xx = border.getIndex(x + i + offsetB);
                    if (isLarger && xx >= input.width) continue;
                    wavelet += input.get(xx, y) * beta[i];
                }
                outX = x / 2;
                output.set(outX, y, scale);
                output.set(output.width / 2 + outX, y, wavelet);
            }
            for (x = upperBorder; x < width; x += 2) {
                scale = 0.0f;
                wavelet = 0.0f;
                for (i = 0; i < alpha.length; ++i) {
                    xx = border.getIndex(x + i + offsetA);
                    if (isLarger && xx >= input.width) continue;
                    scale += input.get(xx, y) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    xx = border.getIndex(x + i + offsetB);
                    if (isLarger && xx >= input.width) continue;
                    wavelet += input.get(xx, y) * beta[i];
                }
                outX = x / 2;
                output.set(outX, y, scale);
                output.set(output.width / 2 + outX, y, wavelet);
            }
        }
    }

    public static void vertical(BorderIndex1D border, WlCoef_F32 coefficients, ImageFloat32 input, ImageFloat32 output) {
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        float[] alpha = coefficients.scaling;
        float[] beta = coefficients.wavelet;
        border.setLength(input.height + input.height % 2);
        boolean isLarger = output.height > input.height;
        int width = input.width;
        int height = input.height + input.height % 2;
        int lowerBorder = UtilWavelet.borderForwardLower(coefficients);
        int upperBorder = input.height - UtilWavelet.borderForwardUpper(coefficients, input.height);
        for (int x = 0; x < width; ++x) {
            int outY;
            int yy;
            int i;
            float wavelet;
            float scale;
            int y;
            for (y = 0; y < lowerBorder; y += 2) {
                scale = 0.0f;
                wavelet = 0.0f;
                for (i = 0; i < alpha.length; ++i) {
                    yy = border.getIndex(y + i + offsetA);
                    if (isLarger && yy >= input.height) continue;
                    scale += input.get(x, yy) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    yy = border.getIndex(y + i + offsetB);
                    if (isLarger && yy >= input.height) continue;
                    wavelet += input.get(x, yy) * beta[i];
                }
                outY = y / 2;
                output.set(x, outY, scale);
                output.set(x, output.height / 2 + outY, wavelet);
            }
            for (y = upperBorder; y < height; y += 2) {
                scale = 0.0f;
                wavelet = 0.0f;
                for (i = 0; i < alpha.length; ++i) {
                    yy = border.getIndex(y + i + offsetA);
                    if (isLarger && yy >= input.height) continue;
                    scale += input.get(x, yy) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    yy = border.getIndex(y + i + offsetB);
                    if (isLarger && yy >= input.height) continue;
                    wavelet += input.get(x, yy) * beta[i];
                }
                outY = y / 2;
                output.set(x, outY, scale);
                output.set(x, output.height / 2 + outY, wavelet);
            }
        }
    }

    public static void horizontalInverse(BorderIndex1D border, WlBorderCoef<WlCoef_F32> desc, ImageFloat32 input, ImageFloat32 output) {
        int i;
        float[] trends = new float[input.width];
        float[] details = new float[input.width];
        int height = output.height;
        int paddedWidth = output.width + output.width % 2;
        WlCoef_F32 inner = desc.getInnerCoefficients();
        int lowerExtra = -Math.min(inner.offsetScaling, inner.offsetWavelet);
        int upperExtra = Math.max(((WlCoef)inner).getScalingLength() + inner.offsetScaling, ((WlCoef)inner).getWaveletLength() + inner.offsetWavelet);
        lowerExtra += lowerExtra % 2;
        upperExtra += upperExtra % 2;
        int lowerBorder = (UtilWavelet.borderInverseLower(desc, border) + lowerExtra) / 2;
        int upperBorder = (UtilWavelet.borderInverseUpper(desc, border, output.width) + upperExtra) / 2;
        boolean isLarger = input.width >= output.width;
        int lowerCompute = lowerBorder * 2 - lowerExtra;
        int upperCompute = upperBorder * 2 - upperExtra;
        int[] indexes = new int[lowerBorder + upperBorder];
        for (i = 0; i < lowerBorder; ++i) {
            indexes[i] = i * 2;
        }
        for (i = lowerBorder; i < indexes.length; ++i) {
            indexes[i] = paddedWidth - (indexes.length - i) * 2;
        }
        border.setLength(output.width + output.width % 2);
        for (int y = 0; y < height; ++y) {
            int x;
            int i2;
            for (i2 = 0; i2 < indexes.length; ++i2) {
                x = indexes[i2];
                details[x] = 0.0f;
                trends[x] = 0.0f;
                details[++x] = 0.0f;
                trends[x] = 0.0f;
            }
            for (i2 = 0; i2 < indexes.length; ++i2) {
                int xx;
                int j;
                x = indexes[i2];
                float a = input.get(x / 2, y);
                float d = input.get(input.width / 2 + x / 2, y);
                WlCoef_F32 coefficients = x < lowerBorder ? desc.getBorderCoefficients(x) : (x >= upperBorder ? desc.getBorderCoefficients(x - paddedWidth) : desc.getInnerCoefficients());
                int offsetA = coefficients.offsetScaling;
                int offsetB = coefficients.offsetWavelet;
                float[] alpha = coefficients.scaling;
                float[] beta = coefficients.wavelet;
                for (j = 0; j < alpha.length; ++j) {
                    xx = border.getIndex(x + offsetA + j);
                    if (isLarger && xx >= output.width) continue;
                    int n = xx;
                    trends[n] = trends[n] + a * alpha[j];
                }
                for (j = 0; j < beta.length; ++j) {
                    xx = border.getIndex(x + offsetB + j);
                    if (isLarger && xx >= output.width) continue;
                    int n = xx;
                    details[n] = details[n] + d * beta[j];
                }
            }
            int indexDst = output.startIndex + y * output.stride;
            for (x = 0; x < lowerCompute; ++x) {
                output.data[indexDst + x] = trends[x] + details[x];
            }
            for (x = paddedWidth - upperCompute; x < output.width; ++x) {
                output.data[indexDst + x] = trends[x] + details[x];
            }
        }
    }

    public static void verticalInverse(BorderIndex1D border, WlBorderCoef<WlCoef_F32> desc, ImageFloat32 input, ImageFloat32 output) {
        int i;
        float[] trends = new float[input.height];
        float[] details = new float[input.height];
        int width = output.width;
        int paddedHeight = output.height + output.height % 2;
        WlCoef_F32 inner = desc.getInnerCoefficients();
        int lowerExtra = -Math.min(inner.offsetScaling, inner.offsetWavelet);
        int upperExtra = Math.max(((WlCoef)inner).getScalingLength() + inner.offsetScaling, ((WlCoef)inner).getWaveletLength() + inner.offsetWavelet);
        lowerExtra += lowerExtra % 2;
        upperExtra += upperExtra % 2;
        int lowerBorder = (UtilWavelet.borderInverseLower(desc, border) + lowerExtra) / 2;
        int upperBorder = (UtilWavelet.borderInverseUpper(desc, border, output.height) + upperExtra) / 2;
        boolean isLarger = input.height >= output.height;
        int lowerCompute = lowerBorder * 2 - lowerExtra;
        int upperCompute = upperBorder * 2 - upperExtra;
        int[] indexes = new int[lowerBorder + upperBorder];
        for (i = 0; i < lowerBorder; ++i) {
            indexes[i] = i * 2;
        }
        for (i = lowerBorder; i < indexes.length; ++i) {
            indexes[i] = paddedHeight - (indexes.length - i) * 2;
        }
        border.setLength(output.height + output.height % 2);
        for (int x = 0; x < width; ++x) {
            int y;
            int i2;
            for (i2 = 0; i2 < indexes.length; ++i2) {
                y = indexes[i2];
                details[y] = 0.0f;
                trends[y] = 0.0f;
                details[++y] = 0.0f;
                trends[y] = 0.0f;
            }
            for (i2 = 0; i2 < indexes.length; ++i2) {
                int yy;
                int j;
                y = indexes[i2];
                float a = input.get(x, y / 2);
                float d = input.get(x, input.height / 2 + y / 2);
                WlCoef_F32 coefficients = y < lowerBorder ? desc.getBorderCoefficients(y) : (y >= upperBorder ? desc.getBorderCoefficients(y - paddedHeight) : desc.getInnerCoefficients());
                int offsetA = coefficients.offsetScaling;
                int offsetB = coefficients.offsetWavelet;
                float[] alpha = coefficients.scaling;
                float[] beta = coefficients.wavelet;
                for (j = 0; j < alpha.length; ++j) {
                    yy = border.getIndex(y + offsetA + j);
                    if (isLarger && yy >= output.height) continue;
                    int n = yy;
                    trends[n] = trends[n] + a * alpha[j];
                }
                for (j = 0; j < beta.length; ++j) {
                    yy = border.getIndex(y + offsetB + j);
                    if (isLarger && yy >= output.height) continue;
                    int n = yy;
                    details[n] = details[n] + d * beta[j];
                }
            }
            int indexDst = output.startIndex + x;
            for (y = 0; y < lowerCompute; ++y) {
                output.data[indexDst + y * output.stride] = trends[y] + details[y];
            }
            for (y = paddedHeight - upperCompute; y < output.height; ++y) {
                output.data[indexDst + y * output.stride] = trends[y] + details[y];
            }
        }
    }

    public static void horizontal(BorderIndex1D border, WlCoef_I32 coefficients, ImageSInt32 input, ImageSInt32 output) {
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        int[] alpha = coefficients.scaling;
        int[] beta = coefficients.wavelet;
        border.setLength(input.width + input.width % 2);
        boolean isLarger = output.width > input.width;
        int width = input.width + input.width % 2;
        int height = input.height;
        int lowerBorder = UtilWavelet.borderForwardLower(coefficients);
        int upperBorder = input.width - UtilWavelet.borderForwardUpper(coefficients, input.width);
        for (int y = 0; y < height; ++y) {
            int outX;
            int xx;
            int i;
            int wavelet;
            int scale;
            int x;
            for (x = 0; x < lowerBorder; x += 2) {
                scale = 0;
                wavelet = 0;
                for (i = 0; i < alpha.length; ++i) {
                    xx = border.getIndex(x + i + offsetA);
                    if (isLarger && xx >= input.width) continue;
                    scale += input.get(xx, y) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    xx = border.getIndex(x + i + offsetB);
                    if (isLarger && xx >= input.width) continue;
                    wavelet += input.get(xx, y) * beta[i];
                }
                scale = 2 * scale / coefficients.denominatorScaling;
                wavelet = 2 * wavelet / coefficients.denominatorWavelet;
                outX = x / 2;
                output.set(outX, y, scale);
                output.set(output.width / 2 + outX, y, wavelet);
            }
            for (x = upperBorder; x < width; x += 2) {
                scale = 0;
                wavelet = 0;
                for (i = 0; i < alpha.length; ++i) {
                    xx = border.getIndex(x + i + offsetA);
                    if (isLarger && xx >= input.width) continue;
                    scale += input.get(xx, y) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    xx = border.getIndex(x + i + offsetB);
                    if (isLarger && xx >= input.width) continue;
                    wavelet += input.get(xx, y) * beta[i];
                }
                outX = x / 2;
                scale = 2 * scale / coefficients.denominatorScaling;
                wavelet = 2 * wavelet / coefficients.denominatorWavelet;
                output.set(outX, y, scale);
                output.set(output.width / 2 + outX, y, wavelet);
            }
        }
    }

    public static void vertical(BorderIndex1D border, WlCoef_I32 coefficients, ImageSInt32 input, ImageSInt32 output) {
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        int[] alpha = coefficients.scaling;
        int[] beta = coefficients.wavelet;
        border.setLength(input.height + input.height % 2);
        boolean isLarger = output.height > input.height;
        int width = input.width;
        int height = input.height + input.height % 2;
        int lowerBorder = UtilWavelet.borderForwardLower(coefficients);
        int upperBorder = input.height - UtilWavelet.borderForwardUpper(coefficients, input.height);
        for (int x = 0; x < width; ++x) {
            int outY;
            int yy;
            int i;
            int wavelet;
            int scale;
            int y;
            for (y = 0; y < lowerBorder; y += 2) {
                scale = 0;
                wavelet = 0;
                for (i = 0; i < alpha.length; ++i) {
                    yy = border.getIndex(y + i + offsetA);
                    if (isLarger && yy >= input.height) continue;
                    scale += input.get(x, yy) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    yy = border.getIndex(y + i + offsetB);
                    if (isLarger && yy >= input.height) continue;
                    wavelet += input.get(x, yy) * beta[i];
                }
                outY = y / 2;
                scale = 2 * scale / coefficients.denominatorScaling;
                wavelet = 2 * wavelet / coefficients.denominatorWavelet;
                output.set(x, outY, scale);
                output.set(x, output.height / 2 + outY, wavelet);
            }
            for (y = upperBorder; y < height; y += 2) {
                scale = 0;
                wavelet = 0;
                for (i = 0; i < alpha.length; ++i) {
                    yy = border.getIndex(y + i + offsetA);
                    if (isLarger && yy >= input.height) continue;
                    scale += input.get(x, yy) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    yy = border.getIndex(y + i + offsetB);
                    if (isLarger && yy >= input.height) continue;
                    wavelet += input.get(x, yy) * beta[i];
                }
                outY = y / 2;
                scale = 2 * scale / coefficients.denominatorScaling;
                wavelet = 2 * wavelet / coefficients.denominatorWavelet;
                output.set(x, outY, scale);
                output.set(x, output.height / 2 + outY, wavelet);
            }
        }
    }

    public static void horizontalInverse(BorderIndex1D border, WlBorderCoef<WlCoef_I32> desc, ImageSInt32 input, ImageSInt32 output) {
        int i;
        int[] trends = new int[input.width];
        int[] details = new int[input.width];
        int height = output.height;
        int paddedWidth = output.width + output.width % 2;
        WlCoef_I32 inner = desc.getInnerCoefficients();
        int lowerExtra = -Math.min(inner.offsetScaling, inner.offsetWavelet);
        int upperExtra = Math.max(((WlCoef)inner).getScalingLength() + inner.offsetScaling, ((WlCoef)inner).getWaveletLength() + inner.offsetWavelet);
        lowerExtra += lowerExtra % 2;
        upperExtra += upperExtra % 2;
        int lowerBorder = (UtilWavelet.borderInverseLower(desc, border) + lowerExtra) / 2;
        int upperBorder = (UtilWavelet.borderInverseUpper(desc, border, output.width) + upperExtra) / 2;
        boolean isLarger = input.width >= output.width;
        int lowerCompute = lowerBorder * 2 - lowerExtra;
        int upperCompute = upperBorder * 2 - upperExtra;
        int[] indexes = new int[lowerBorder + upperBorder];
        for (i = 0; i < lowerBorder; ++i) {
            indexes[i] = i * 2;
        }
        for (i = lowerBorder; i < indexes.length; ++i) {
            indexes[i] = paddedWidth - (indexes.length - i) * 2;
        }
        border.setLength(output.width + output.width % 2);
        WlCoef_I32 coefficients = desc.getInnerCoefficients();
        int e = coefficients.denominatorScaling * 2;
        int f = coefficients.denominatorWavelet * 2;
        int ef = e * f;
        int ef2 = ef / 2;
        for (int y = 0; y < height; ++y) {
            int x;
            int i2;
            for (i2 = 0; i2 < indexes.length; ++i2) {
                x = indexes[i2];
                details[x] = 0;
                trends[x] = 0;
                details[++x] = 0;
                trends[x] = 0;
            }
            for (i2 = 0; i2 < indexes.length; ++i2) {
                int xx;
                int j;
                x = indexes[i2];
                float a = input.get(x / 2, y);
                float d = input.get(input.width / 2 + x / 2, y);
                coefficients = x < lowerBorder ? desc.getBorderCoefficients(x) : (x >= upperBorder ? desc.getBorderCoefficients(x - paddedWidth) : desc.getInnerCoefficients());
                int offsetA = coefficients.offsetScaling;
                int offsetB = coefficients.offsetWavelet;
                int[] alpha = coefficients.scaling;
                int[] beta = coefficients.wavelet;
                for (j = 0; j < alpha.length; ++j) {
                    xx = border.getIndex(x + offsetA + j);
                    if (isLarger && xx >= output.width) continue;
                    int n = xx;
                    trends[n] = (int)((float)trends[n] + a * (float)alpha[j]);
                }
                for (j = 0; j < beta.length; ++j) {
                    xx = border.getIndex(x + offsetB + j);
                    if (isLarger && xx >= output.width) continue;
                    int n = xx;
                    details[n] = (int)((float)details[n] + d * (float)beta[j]);
                }
            }
            int indexDst = output.startIndex + y * output.stride;
            for (x = 0; x < lowerCompute; ++x) {
                output.data[indexDst + x] = UtilWavelet.round(trends[x] * f + details[x] * e, ef2, ef);
            }
            for (x = paddedWidth - upperCompute; x < output.width; ++x) {
                output.data[indexDst + x] = UtilWavelet.round(trends[x] * f + details[x] * e, ef2, ef);
            }
        }
    }

    public static void verticalInverse(BorderIndex1D border, WlBorderCoef<WlCoef_I32> desc, ImageSInt32 input, ImageSInt32 output) {
        int i;
        int[] trends = new int[input.height];
        int[] details = new int[input.height];
        int width = output.width;
        int paddedHeight = output.height + output.height % 2;
        WlCoef_I32 inner = desc.getInnerCoefficients();
        int lowerExtra = -Math.min(inner.offsetScaling, inner.offsetWavelet);
        int upperExtra = Math.max(((WlCoef)inner).getScalingLength() + inner.offsetScaling, ((WlCoef)inner).getWaveletLength() + inner.offsetWavelet);
        lowerExtra += lowerExtra % 2;
        upperExtra += upperExtra % 2;
        int lowerBorder = (UtilWavelet.borderInverseLower(desc, border) + lowerExtra) / 2;
        int upperBorder = (UtilWavelet.borderInverseUpper(desc, border, output.height) + upperExtra) / 2;
        boolean isLarger = input.height >= output.height;
        int lowerCompute = lowerBorder * 2 - lowerExtra;
        int upperCompute = upperBorder * 2 - upperExtra;
        int[] indexes = new int[lowerBorder + upperBorder];
        for (i = 0; i < lowerBorder; ++i) {
            indexes[i] = i * 2;
        }
        for (i = lowerBorder; i < indexes.length; ++i) {
            indexes[i] = paddedHeight - (indexes.length - i) * 2;
        }
        border.setLength(output.height + output.height % 2);
        WlCoef_I32 coefficients = desc.getInnerCoefficients();
        int e = coefficients.denominatorScaling * 2;
        int f = coefficients.denominatorWavelet * 2;
        int ef = e * f;
        int ef2 = ef / 2;
        for (int x = 0; x < width; ++x) {
            int y;
            int i2;
            for (i2 = 0; i2 < indexes.length; ++i2) {
                y = indexes[i2];
                details[y] = 0;
                trends[y] = 0;
                details[++y] = 0;
                trends[y] = 0;
            }
            for (i2 = 0; i2 < indexes.length; ++i2) {
                int yy;
                int j;
                y = indexes[i2];
                float a = input.get(x, y / 2);
                float d = input.get(x, input.height / 2 + y / 2);
                coefficients = y < lowerBorder ? desc.getBorderCoefficients(y) : (y >= upperBorder ? desc.getBorderCoefficients(y - paddedHeight) : desc.getInnerCoefficients());
                int offsetA = coefficients.offsetScaling;
                int offsetB = coefficients.offsetWavelet;
                int[] alpha = coefficients.scaling;
                int[] beta = coefficients.wavelet;
                for (j = 0; j < alpha.length; ++j) {
                    yy = border.getIndex(y + offsetA + j);
                    if (isLarger && yy >= output.height) continue;
                    int n = yy;
                    trends[n] = (int)((float)trends[n] + a * (float)alpha[j]);
                }
                for (j = 0; j < beta.length; ++j) {
                    yy = border.getIndex(y + offsetB + j);
                    if (isLarger && yy >= output.height) continue;
                    int n = yy;
                    details[n] = (int)((float)details[n] + d * (float)beta[j]);
                }
            }
            int indexDst = output.startIndex + x;
            for (y = 0; y < lowerCompute; ++y) {
                output.data[indexDst + y * output.stride] = UtilWavelet.round(trends[y] * f + details[y] * e, ef2, ef);
            }
            for (y = paddedHeight - upperCompute; y < output.height; ++y) {
                output.data[indexDst + y * output.stride] = UtilWavelet.round(trends[y] * f + details[y] * e, ef2, ef);
            }
        }
    }
}

