/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.core.image.ConvertRaster;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInterleavedInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.reflect.Array;
import java.security.AccessControlException;
import javax.swing.JComponent;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.IntegerInterleavedRaster;
import sun.awt.image.ShortInterleavedRaster;

public class ConvertBufferedImage {
    public static ImageInterleavedInt8 extractInterlacedInt8(BufferedImage img) {
        if (img.getRaster() instanceof ByteInterleavedRaster && img.getType() != 13) {
            ByteInterleavedRaster raster = (ByteInterleavedRaster)img.getRaster();
            ImageInterleavedInt8 ret = new ImageInterleavedInt8();
            ret.width = img.getWidth();
            ret.height = img.getHeight();
            ret.stride = ret.width;
            ret.numBands = raster.getNumBands();
            ret.data = raster.getDataStorage();
            return ret;
        }
        throw new IllegalArgumentException("Buffered image does not have an interlaced int raster");
    }

    public static ImageUInt8 extractImageInt8(BufferedImage img) {
        if (img.getRaster() instanceof ByteInterleavedRaster && img.getType() != 13) {
            if (ConvertBufferedImage.isSubImage(img)) {
                throw new IllegalArgumentException("Sub-images of BufferedImages are not yet supported");
            }
            ByteInterleavedRaster raster = (ByteInterleavedRaster)img.getRaster();
            if (raster.getNumBands() != 1) {
                throw new IllegalArgumentException("Input image has more than one channel");
            }
            ImageUInt8 ret = new ImageUInt8();
            ret.width = img.getWidth();
            ret.height = img.getHeight();
            ret.stride = ret.width;
            ret.data = raster.getDataStorage();
            return ret;
        }
        throw new IllegalArgumentException("Buffered image does not have a gray scale byte raster");
    }

    public static BufferedImage extractBuffered(ImageInterleavedInt8 img) {
        ComponentColorModel colorModel;
        ColorSpace cs;
        if (img.isSubimage()) {
            throw new IllegalArgumentException("Sub-images are not supported for this operation");
        }
        int width = img.width;
        int height = img.height;
        int numBands = img.numBands;
        DataBufferByte bufferByte = new DataBufferByte(img.data, width * height * numBands, 0);
        int[] bOffs = null;
        if (numBands == 3) {
            cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8};
            bOffs = new int[]{2, 1, 0};
            colorModel = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        } else if (numBands == 1) {
            cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{8};
            bOffs = new int[]{0};
            colorModel = new ComponentColorModel(cs, nBits, false, true, 1, 0);
        } else {
            throw new IllegalArgumentException("Only 1 or 3 bands supported");
        }
        WritableRaster raster = Raster.createInterleavedRaster(bufferByte, width, height, img.stride, numBands, bOffs, new Point(0, 0));
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage extractBuffered(ImageUInt8 img) {
        if (img.isSubimage()) {
            throw new IllegalArgumentException("Sub-images are not supported for this operation");
        }
        int width = img.width;
        int height = img.height;
        DataBufferByte bufferByte = new DataBufferByte(img.data, width * height, 0);
        int[] bOffs = new int[]{0};
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] nBits = new int[]{8};
        ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, false, true, 1, 0);
        WritableRaster raster = Raster.createInterleavedRaster(bufferByte, width, height, img.stride, 1, bOffs, new Point(0, 0));
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static <T extends ImageBase> void convertFrom(BufferedImage src, T dst) {
        if (dst instanceof ImageSingleBand) {
            ImageSingleBand sb = (ImageSingleBand)dst;
            ConvertBufferedImage.convertFromSingle(src, sb, sb.getClass());
        } else if (dst instanceof MultiSpectral) {
            MultiSpectral ms = (MultiSpectral)dst;
            ConvertBufferedImage.convertFromMulti(src, ms, ms.getType());
        } else {
            throw new IllegalArgumentException("Unknown type " + dst.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> T convertFromSingle(BufferedImage src, T dst, Class<T> type) {
        if (type == ImageUInt8.class) {
            return (T)ConvertBufferedImage.convertFrom(src, (ImageUInt8)dst);
        }
        if (ImageInt16.class.isAssignableFrom(type)) {
            return (T)ConvertBufferedImage.convertFrom(src, (ImageInt16)dst, type);
        }
        if (type == ImageFloat32.class) {
            return (T)ConvertBufferedImage.convertFrom(src, (ImageFloat32)dst);
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static ImageUInt8 convertFrom(BufferedImage src, ImageUInt8 dst) {
        if (dst != null) {
            if (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight()) {
                throw new IllegalArgumentException("image dimension are different");
            }
        } else {
            dst = new ImageUInt8(src.getWidth(), src.getHeight());
        }
        try {
            if (src.getRaster() instanceof ByteInterleavedRaster && src.getType() != 13) {
                ConvertRaster.bufferedToGray((ByteInterleavedRaster)src.getRaster(), dst);
            } else if (src.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.bufferedToGray((IntegerInterleavedRaster)src.getRaster(), dst);
            } else {
                ConvertRaster.bufferedToGray(src, dst);
            }
        }
        catch (AccessControlException e) {
            ConvertRaster.bufferedToGray(src, dst);
        }
        return dst;
    }

    public static <T extends ImageInt16> T convertFrom(BufferedImage src, T dst, Class<T> type) {
        if (dst != null) {
            if (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight()) {
                throw new IllegalArgumentException("image dimension are different");
            }
        } else {
            dst = (ImageInt16)GeneralizedImageOps.createSingleBand(type, src.getWidth(), src.getHeight());
        }
        try {
            if (src.getRaster() instanceof ShortInterleavedRaster) {
                ConvertRaster.bufferedToGray((ShortInterleavedRaster)src.getRaster(), dst);
                return dst;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        ConvertRaster.bufferedToGray(src, dst);
        return dst;
    }

    public static ImageFloat32 convertFrom(BufferedImage src, ImageFloat32 dst) {
        if (dst != null) {
            if (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight()) {
                throw new IllegalArgumentException("image dimension are different");
            }
        } else {
            dst = new ImageFloat32(src.getWidth(), src.getHeight());
        }
        try {
            if (src.getRaster() instanceof ByteInterleavedRaster && src.getType() != 13) {
                ConvertRaster.bufferedToGray((ByteInterleavedRaster)src.getRaster(), dst);
            } else if (src.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.bufferedToGray((IntegerInterleavedRaster)src.getRaster(), dst);
            } else {
                ConvertRaster.bufferedToGray(src, dst);
            }
        }
        catch (AccessControlException e) {
            ConvertRaster.bufferedToGray(src, dst);
        }
        return dst;
    }

    public static <T extends ImageSingleBand> MultiSpectral<T> convertFromMulti(BufferedImage src, MultiSpectral<T> dst, Class<T> type) {
        block25: {
            if (src == null) {
                throw new IllegalArgumentException("src is null!");
            }
            if (dst != null && (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight())) {
                throw new IllegalArgumentException("image dimension are different");
            }
            try {
                WritableRaster raster = src.getRaster();
                int numBands = src.getType() == 13 ? 3 : raster.getNumBands();
                if (dst == null) {
                    dst = new MultiSpectral<T>(type, src.getWidth(), src.getHeight(), numBands);
                } else if (dst.getNumBands() != numBands) {
                    throw new IllegalArgumentException("Expected " + numBands + " bands in dst not " + dst.getNumBands());
                }
                if (type == ImageUInt8.class) {
                    if (src.getRaster() instanceof ByteInterleavedRaster && src.getType() != 13) {
                        if (src.getType() == 10) {
                            for (int i = 0; i < dst.getNumBands(); ++i) {
                                ConvertRaster.bufferedToGray(src, dst.getBand(i));
                            }
                        } else {
                            ConvertRaster.bufferedToMulti_U8((ByteInterleavedRaster)src.getRaster(), dst);
                        }
                    } else if (src.getRaster() instanceof IntegerInterleavedRaster) {
                        ConvertRaster.bufferedToMulti_U8((IntegerInterleavedRaster)src.getRaster(), dst);
                    } else {
                        ConvertRaster.bufferedToMulti_U8(src, dst);
                    }
                    break block25;
                }
                if (type == ImageFloat32.class) {
                    if (src.getRaster() instanceof ByteInterleavedRaster && src.getType() != 13) {
                        if (src.getType() == 10) {
                            for (int i = 0; i < dst.getNumBands(); ++i) {
                                ConvertRaster.bufferedToGray(src, (ImageFloat32)((Object)dst.getBand(i)));
                            }
                        } else {
                            ConvertRaster.bufferedToMulti_F32((ByteInterleavedRaster)src.getRaster(), dst);
                        }
                    } else if (src.getRaster() instanceof IntegerInterleavedRaster) {
                        ConvertRaster.bufferedToMulti_F32((IntegerInterleavedRaster)src.getRaster(), dst);
                    } else {
                        ConvertRaster.bufferedToMulti_F32(src, dst);
                    }
                    break block25;
                }
                throw new IllegalArgumentException("Band type not supported yet");
            }
            catch (AccessControlException e) {
                if (dst == null) {
                    dst = new MultiSpectral<T>(type, src.getWidth(), src.getHeight(), 3);
                }
                if (type == ImageUInt8.class) {
                    ConvertRaster.bufferedToMulti_U8(src, dst);
                }
                if (type != ImageFloat32.class) break block25;
                ConvertRaster.bufferedToMulti_F32(src, dst);
            }
        }
        return dst;
    }

    public static BufferedImage convertTo(ImageBase src, BufferedImage dst) {
        if (src instanceof ImageSingleBand) {
            if (ImageUInt8.class == src.getClass()) {
                return ConvertBufferedImage.convertTo((ImageUInt8)src, dst);
            }
            if (ImageInt16.class.isInstance(src)) {
                return ConvertBufferedImage.convertTo((ImageInt16)src, dst);
            }
            if (ImageFloat32.class == src.getClass()) {
                return ConvertBufferedImage.convertTo((ImageFloat32)src, dst);
            }
            throw new IllegalArgumentException("ImageSingleBand type is not yet supported: " + src.getClass().getSimpleName());
        }
        if (src instanceof MultiSpectral) {
            MultiSpectral ms = (MultiSpectral)src;
            if (ImageUInt8.class == ms.getType()) {
                return ConvertBufferedImage.convertTo_U8(ms, dst);
            }
            if (ImageFloat32.class == ms.getType()) {
                return ConvertBufferedImage.convertTo_F32(ms, dst);
            }
            throw new IllegalArgumentException("MultiSpectral type is not yet supported: " + ms.getType().getSimpleName());
        }
        throw new IllegalArgumentException("Image type is not yet supported: " + src.getClass().getSimpleName());
    }

    public static BufferedImage convertTo(ImageUInt8 src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.grayToBuffered(src, (ByteInterleavedRaster)dst.getRaster());
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.grayToBuffered(src, (IntegerInterleavedRaster)dst.getRaster());
            } else {
                ConvertRaster.grayToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.grayToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo(ImageInt16 src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.grayToBuffered(src, (ByteInterleavedRaster)dst.getRaster());
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.grayToBuffered(src, (IntegerInterleavedRaster)dst.getRaster());
            } else if (dst.getType() == 11) {
                ConvertRaster.grayToBuffered(src, (ShortInterleavedRaster)dst.getRaster());
            } else {
                ConvertRaster.grayToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.grayToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo(ImageFloat32 src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.grayToBuffered(src, (ByteInterleavedRaster)dst.getRaster());
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.grayToBuffered(src, (IntegerInterleavedRaster)dst.getRaster());
            } else {
                ConvertRaster.grayToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.grayToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo_U8(MultiSpectral<ImageUInt8> src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.multToBuffered_U8(src, (ByteInterleavedRaster)dst.getRaster());
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.multToBuffered_U8(src, (IntegerInterleavedRaster)dst.getRaster());
            } else {
                ConvertRaster.multToBuffered_U8(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.multToBuffered_U8(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo_F32(MultiSpectral<ImageFloat32> src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.multToBuffered_F32(src, (ByteInterleavedRaster)dst.getRaster());
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.multToBuffered_F32(src, (IntegerInterleavedRaster)dst.getRaster());
            } else {
                ConvertRaster.multToBuffered_F32(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.multToBuffered_F32(src, dst);
        }
        return dst;
    }

    public static BufferedImage checkInputs(ImageBase src, BufferedImage dst) {
        if (dst != null) {
            if (dst.getWidth() != src.getWidth() || dst.getHeight() != src.getHeight()) {
                throw new IllegalArgumentException("image dimension are different");
            }
        } else {
            dst = ImageInt16.class.isInstance(src) ? new BufferedImage(src.getWidth(), src.getHeight(), 11) : new BufferedImage(src.getWidth(), src.getHeight(), 1);
        }
        return dst;
    }

    public static BufferedImage convertTo(JComponent comp, BufferedImage storage) {
        if (storage == null) {
            storage = new BufferedImage(comp.getWidth(), comp.getHeight(), 1);
        }
        Graphics2D g2 = storage.createGraphics();
        comp.paintComponents(g2);
        return storage;
    }

    public static <T extends ImageSingleBand> void orderBandsIntoRGB(MultiSpectral<T> image, BufferedImage input) {
        boolean swap = false;
        try {
            WritableRaster raster = input.getRaster();
            if (raster instanceof ByteInterleavedRaster) {
                ((ByteInterleavedRaster)raster).getDataStorage();
            } else if (raster instanceof IntegerInterleavedRaster) {
                ((IntegerInterleavedRaster)raster).getDataStorage();
            }
            int bufferedImageType = input.getType();
            if (bufferedImageType == 5 || bufferedImageType == 4 || bufferedImageType == 6) {
                swap = true;
            }
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        if (swap) {
            ImageSingleBand[] temp;
            if (image.getNumBands() == 3) {
                temp = (ImageSingleBand[])Array.newInstance(image.getType(), 3);
                temp[0] = image.getBand(2);
                temp[1] = image.getBand(1);
                temp[2] = image.getBand(0);
                image.bands[0] = temp[0];
                image.bands[1] = temp[1];
                image.bands[2] = temp[2];
            } else if (image.getNumBands() == 4) {
                temp = (ImageSingleBand[])Array.newInstance(image.getType(), 4);
                temp[0] = image.getBand(0);
                temp[1] = image.getBand(3);
                temp[2] = image.getBand(2);
                temp[3] = image.getBand(1);
                image.bands[0] = temp[0];
                image.bands[1] = temp[1];
                image.bands[2] = temp[2];
                image.bands[3] = temp[3];
            }
        }
    }

    public static boolean isSubImage(BufferedImage img) {
        return img.getRaster().getParent() != null;
    }
}

