/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.derivative;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageGradient_Gaussian;
import boofcv.abst.filter.derivative.ImageGradient_Reflection;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.abst.filter.derivative.ImageHessianDirect;
import boofcv.abst.filter.derivative.ImageHessianDirect_Reflection;
import boofcv.abst.filter.derivative.ImageHessian_Reflection;
import boofcv.alg.filter.derivative.GradientPrewitt;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.alg.filter.derivative.HessianFromGradient;
import boofcv.alg.filter.derivative.HessianSobel;
import boofcv.alg.filter.derivative.HessianThree;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import java.lang.reflect.Method;

public class FactoryDerivative {
    public static <I extends ImageSingleBand, D extends ImageSingleBand> ImageGradient<I, D> prewitt(Class<I> inputType, Class<D> derivType) {
        Method m = FactoryDerivative.findDerivative(GradientPrewitt.class, inputType, derivType);
        return new ImageGradient_Reflection(m);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> ImageGradient<I, D> sobel(Class<I> inputType, Class<D> derivType) {
        Method m = FactoryDerivative.findDerivative(GradientSobel.class, inputType, derivType);
        return new ImageGradient_Reflection(m);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> ImageGradient<I, D> three(Class<I> inputType, Class<D> derivType) {
        Method m = FactoryDerivative.findDerivative(GradientThree.class, inputType, derivType);
        return new ImageGradient_Reflection(m);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> ImageHessianDirect<I, D> hessianDirectThree(Class<I> inputType, Class<D> derivType) {
        Method m = FactoryDerivative.findHessian(HessianThree.class, inputType, derivType);
        return new ImageHessianDirect_Reflection(m);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> ImageHessianDirect<I, D> hessianDirectSobel(Class<I> inputType, Class<D> derivType) {
        Method m = FactoryDerivative.findHessian(HessianSobel.class, inputType, derivType);
        return new ImageHessianDirect_Reflection(m);
    }

    public static <D extends ImageSingleBand> ImageHessian<D> hessian(Class<?> gradientType, Class<D> derivType) {
        Method m = FactoryDerivative.findHessianFromGradient(gradientType, derivType);
        return new ImageHessian_Reflection(m);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> ImageGradient<I, D> gaussian(double sigma, int radius, Class<I> inputType, Class<D> derivType) {
        return new ImageGradient_Gaussian<I, D>(sigma, radius, inputType, derivType);
    }

    public static ImageGradient<ImageFloat32, ImageFloat32> gaussian_F32(double sigma, int radius) {
        return FactoryDerivative.gaussian(sigma, radius, ImageFloat32.class, ImageFloat32.class);
    }

    public static ImageGradient<ImageFloat32, ImageFloat32> sobel_F32() {
        return FactoryDerivative.sobel(ImageFloat32.class, ImageFloat32.class);
    }

    public static ImageGradient<ImageFloat32, ImageFloat32> three_F32() {
        return FactoryDerivative.three(ImageFloat32.class, ImageFloat32.class);
    }

    public static ImageHessianDirect<ImageFloat32, ImageFloat32> hessianDirectThree_F32() {
        return FactoryDerivative.hessianDirectThree(ImageFloat32.class, ImageFloat32.class);
    }

    public static ImageHessianDirect<ImageFloat32, ImageFloat32> hessianDirectSobel_F32() {
        return FactoryDerivative.hessianDirectSobel(ImageFloat32.class, ImageFloat32.class);
    }

    public static ImageGradient<ImageUInt8, ImageSInt16> gaussian_I8(double sigma, int radius) {
        return FactoryDerivative.gaussian(sigma, radius, ImageUInt8.class, ImageSInt16.class);
    }

    public static ImageGradient<ImageUInt8, ImageSInt16> sobel_I8() {
        return FactoryDerivative.sobel(ImageUInt8.class, ImageSInt16.class);
    }

    public static ImageGradient<ImageUInt8, ImageSInt16> three_I8() {
        return FactoryDerivative.three(ImageUInt8.class, ImageSInt16.class);
    }

    public static ImageHessianDirect<ImageUInt8, ImageSInt16> hessianDirectThree_I8() {
        return FactoryDerivative.hessianDirectThree(ImageUInt8.class, ImageSInt16.class);
    }

    public static ImageHessianDirect<ImageUInt8, ImageSInt16> hessianDirectSobel_I8() {
        return FactoryDerivative.hessianDirectSobel(ImageUInt8.class, ImageSInt16.class);
    }

    public static <D extends ImageSingleBand> ImageHessian<D> hessianSobel(Class<D> derivType) {
        if (derivType == ImageFloat32.class) {
            return FactoryDerivative.hessian(GradientSobel.class, ImageFloat32.class);
        }
        if (derivType == ImageSInt16.class) {
            return FactoryDerivative.hessian(GradientSobel.class, ImageSInt16.class);
        }
        throw new IllegalArgumentException("Not supported yet");
    }

    public static <D extends ImageSingleBand> ImageHessian<D> hessianPrewitt(Class<D> derivType) {
        if (derivType == ImageFloat32.class) {
            return FactoryDerivative.hessian(GradientPrewitt.class, ImageFloat32.class);
        }
        if (derivType == ImageSInt16.class) {
            return FactoryDerivative.hessian(GradientPrewitt.class, ImageSInt16.class);
        }
        throw new IllegalArgumentException("Not supported yet");
    }

    public static <D extends ImageSingleBand> ImageHessian<D> hessianThree(Class<D> derivType) {
        if (derivType == ImageFloat32.class) {
            return FactoryDerivative.hessian(GradientThree.class, ImageFloat32.class);
        }
        if (derivType == ImageSInt16.class) {
            return FactoryDerivative.hessian(GradientThree.class, ImageSInt16.class);
        }
        throw new IllegalArgumentException("Not supported yet");
    }

    private static Method findDerivative(Class<?> derivativeClass, Class<?> inputType, Class<?> derivType) {
        Method m;
        try {
            Class borderType = GeneralizedImageOps.isFloatingPoint(inputType) ? ImageBorder_F32.class : ImageBorder_I32.class;
            m = derivativeClass.getDeclaredMethod("process", inputType, derivType, derivType, borderType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Input and derivative types are probably not compatible", e);
        }
        return m;
    }

    private static Method findHessian(Class<?> derivativeClass, Class<?> inputType, Class<?> derivType) {
        Method m;
        try {
            Class borderType = GeneralizedImageOps.isFloatingPoint(inputType) ? ImageBorder_F32.class : ImageBorder_I32.class;
            m = derivativeClass.getDeclaredMethod("process", inputType, derivType, derivType, derivType, borderType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Input and derivative types are probably not compatible", e);
        }
        return m;
    }

    private static Method findHessianFromGradient(Class<?> derivativeClass, Class<?> imageType) {
        Method m;
        String name = derivativeClass.getSimpleName().substring(8);
        try {
            Class borderType = GeneralizedImageOps.isFloatingPoint(imageType) ? ImageBorder_F32.class : ImageBorder_I32.class;
            m = HessianFromGradient.class.getDeclaredMethod("hessian" + name, imageType, imageType, imageType, imageType, imageType, borderType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Input and derivative types are probably not compatible", e);
        }
        return m;
    }
}

