/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.core.image.ConvertBufferedImage;
import boofcv.struct.GrowQueue_I8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import javax.imageio.ImageIO;
import sun.awt.image.IntegerInterleavedRaster;

public class UtilImageIO {
    public static BufferedImage loadImage(String fileName) {
        BufferedImage img;
        try {
            img = ImageIO.read(new File(fileName));
            if (img == null && fileName.endsWith("ppm") || fileName.endsWith("PPM")) {
                return UtilImageIO.loadPPM(fileName, null);
            }
        }
        catch (IOException e) {
            return null;
        }
        return img;
    }

    public static <T extends ImageSingleBand> T loadImage(String fileName, Class<T> imageType) {
        BufferedImage img = UtilImageIO.loadImage(fileName);
        if (img == null) {
            return null;
        }
        return (T)ConvertBufferedImage.convertFromSingle(img, null, imageType);
    }

    public static void saveImage(BufferedImage img, String fileName) {
        block3: {
            try {
                String[] a = fileName.split("[.]");
                String type = a.length > 0 ? a[a.length - 1] : "jpg";
                if (ImageIO.write((RenderedImage)img, type, new File(fileName))) break block3;
                if (fileName.endsWith("ppm") || fileName.endsWith("PPM")) {
                    MultiSpectral<ImageUInt8> color = ConvertBufferedImage.convertFromMulti(img, null, ImageUInt8.class);
                    ConvertBufferedImage.orderBandsIntoRGB(color, img);
                    UtilImageIO.savePPM(color, fileName, null);
                    break block3;
                }
                throw new IllegalArgumentException("No writter appropriate found");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static BufferedImage loadPPM(String fileName, BufferedImage storage) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(fileName));
        UtilImageIO.readLine(in);
        String[] s = UtilImageIO.readLine(in).split(" ");
        int w = Integer.parseInt(s[0]);
        int h = Integer.parseInt(s[1]);
        UtilImageIO.readLine(in);
        if (storage == null || storage.getWidth() != w || storage.getHeight() != h) {
            storage = new BufferedImage(w, h, 1);
        }
        int length = w * h * 3;
        byte[] data = new byte[length];
        in.read(data, 0, length);
        boolean useFailSafe = storage.getType() != 1;
        try {
            int[] rgb = ((IntegerInterleavedRaster)storage.getRaster()).getDataStorage();
            int indexIn = 0;
            int indexOut = 0;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    rgb[indexOut++] = (data[indexIn++] & 0xFF) << 16 | (data[indexIn++] & 0xFF) << 8 | data[indexIn++] & 0xFF;
                }
            }
        }
        catch (AccessControlException e) {
            useFailSafe = true;
        }
        if (useFailSafe) {
            int indexIn = 0;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    storage.setRGB(x, y, (data[indexIn++] & 0xFF) << 16 | (data[indexIn++] & 0xFF) << 8 | data[indexIn++] & 0xFF);
                }
            }
        }
        return storage;
    }

    public static MultiSpectral<ImageUInt8> loadPPM_U8(String fileName, MultiSpectral<ImageUInt8> storage, GrowQueue_I8 temp) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(fileName));
        UtilImageIO.readLine(in);
        String[] s = UtilImageIO.readLine(in).split(" ");
        int w = Integer.parseInt(s[0]);
        int h = Integer.parseInt(s[1]);
        UtilImageIO.readLine(in);
        if (storage == null || storage.getNumBands() != 3) {
            storage = new MultiSpectral<ImageUInt8>(ImageUInt8.class, w, h, 3);
        } else {
            storage.reshape(w, h);
        }
        int length = w * h * 3;
        if (temp == null) {
            temp = new GrowQueue_I8(length);
        }
        temp.resize(length);
        byte[] data = temp.data;
        in.read(data, 0, length);
        ImageUInt8 band0 = storage.getBand(0);
        ImageUInt8 band1 = storage.getBand(1);
        ImageUInt8 band2 = storage.getBand(2);
        int indexIn = 0;
        for (int y = 0; y < storage.height; ++y) {
            int indexOut = storage.startIndex + y * storage.stride;
            int x = 0;
            while (x < storage.width) {
                band0.data[indexOut] = data[indexIn++];
                band1.data[indexOut] = data[indexIn++];
                band2.data[indexOut] = data[indexIn++];
                ++x;
                ++indexOut;
            }
        }
        return storage;
    }

    public static void savePPM(MultiSpectral<ImageUInt8> rgb, String fileName, GrowQueue_I8 temp) throws IOException {
        File out = new File(fileName);
        DataOutputStream os = new DataOutputStream(new FileOutputStream(out));
        String header = String.format("P6\n%d %d\n255\n", rgb.width, rgb.height);
        os.write(header.getBytes());
        int length = rgb.width * rgb.height * 3;
        if (temp == null) {
            temp = new GrowQueue_I8(length);
        }
        temp.resize(length);
        byte[] data = temp.data;
        ImageUInt8 band0 = rgb.getBand(0);
        ImageUInt8 band1 = rgb.getBand(1);
        ImageUInt8 band2 = rgb.getBand(2);
        int indexOut = 0;
        for (int y = 0; y < rgb.height; ++y) {
            int index = rgb.startIndex + y * rgb.stride;
            int x = 0;
            while (x < rgb.width) {
                data[indexOut++] = band0.data[index];
                data[indexOut++] = band1.data[index];
                data[indexOut++] = band2.data[index];
                ++x;
                ++index;
            }
        }
        os.write(data, 0, rgb.width * rgb.height * 3);
        os.close();
    }

    private static String readLine(DataInputStream in) throws IOException {
        String s = "";
        int b;
        while ((b = in.read()) != 10) {
            s = s + (char)b;
        }
        return s;
    }
}

