/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper.images;

import boofcv.core.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.video.VideoMjpegCodec;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class MjpegStreamSequence<T extends ImageBase>
implements SimpleImageSequence<T> {
    VideoMjpegCodec codec = new VideoMjpegCodec();
    DataInputStream in;
    BufferedImage original;
    BufferedImage next;
    T image;
    int frameNumber;
    ImageDataType<T> imageType;

    public MjpegStreamSequence(InputStream in, ImageDataType<T> imageType) {
        this.in = new DataInputStream(in);
        this.imageType = imageType;
        this.image = imageType.createImage(1, 1);
        this.readNext();
    }

    public MjpegStreamSequence(String fileName, ImageDataType<T> imageType) throws FileNotFoundException {
        this(new DataInputStream(new BufferedInputStream(new FileInputStream(fileName), 204800)), imageType);
    }

    private void readNext() {
        byte[] data = this.codec.readFrame(this.in);
        if (data == null) {
            this.original = null;
        } else {
            try {
                this.next = ImageIO.read(new ByteArrayInputStream(data));
                ++this.frameNumber;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        this.original = this.next;
        ((ImageBase)this.image).reshape(this.original.getWidth(), this.original.getHeight());
        ConvertBufferedImage.convertFrom(this.original, this.image);
        this.readNext();
        return this.image;
    }

    @Override
    public BufferedImage getGuiImage() {
        return this.original;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.in = null;
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber - 1;
    }

    @Override
    public void setLoop(boolean loop) {
        throw new RuntimeException("Can't loop");
    }

    @Override
    public ImageDataType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public void reset() {
        throw new RuntimeException("Reset not supported");
    }
}

