/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

import boofcv.struct.convolve.Kernel1D;

public class Kernel1D_I32
extends Kernel1D {
    public int[] data;

    public Kernel1D_I32(int[] data, int width) {
        if (width % 2 == 0 && width <= 0) {
            throw new IllegalArgumentException("invalid width");
        }
        this.width = width;
        this.data = new int[width];
        System.arraycopy(data, 0, this.data, 0, width);
    }

    public Kernel1D_I32(int width) {
        if (width % 2 == 0 && width <= 0) {
            throw new IllegalArgumentException("invalid width");
        }
        this.data = new int[width];
        this.width = width;
    }

    public Kernel1D_I32(int width, int ... values) {
        if (width % 2 == 0 && width <= 0) {
            throw new IllegalArgumentException("invalid width");
        }
        this.data = new int[width];
        this.width = width;
        System.arraycopy(values, 0, this.data, 0, width);
    }

    protected Kernel1D_I32() {
    }

    public static Kernel1D_I32 wrap(int[] data, int width) {
        if (width % 2 == 0 && width <= 0 && width > data.length) {
            throw new IllegalArgumentException("invalid width");
        }
        Kernel1D_I32 ret = new Kernel1D_I32();
        ret.data = data;
        ret.width = width;
        return ret;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    public int[] getData() {
        return this.data;
    }

    public int get(int i) {
        return this.data[i];
    }

    public int computeSum() {
        int sum = 0;
        for (int i = 0; i < this.data.length; ++i) {
            sum += this.data[i];
        }
        return sum;
    }
}

