/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageTypeInfo;
import boofcv.struct.image.MultiSpectral;
import java.lang.reflect.Array;

public class ImageDataType<T extends ImageBase> {
    Family family;
    ImageTypeInfo dataType;
    int numBands;

    public ImageDataType(Family family, ImageTypeInfo dataType, int numBands) {
        this.family = family;
        this.dataType = dataType;
        this.numBands = numBands;
    }

    public static <I extends ImageSingleBand> ImageDataType<I> single(Class<I> imageType) {
        return new ImageDataType(Family.SINGLE_BAND, ImageTypeInfo.classToType(imageType), 1);
    }

    public static <I extends ImageSingleBand> ImageDataType<MultiSpectral<I>> ms(int numBands, Class<I> imageType) {
        return new ImageDataType<MultiSpectral<I>>(Family.MULTI_SPECTRAL, ImageTypeInfo.classToType(imageType), numBands);
    }

    public ImageTypeInfo getDataType() {
        return this.dataType;
    }

    public T createImage(int width, int height) {
        switch (this.family) {
            case SINGLE_BAND: {
                return GeneralizedImageOps.createSingleBand(this.dataType.getImageClass(), width, height);
            }
            case MULTI_SPECTRAL: {
                return (T)new MultiSpectral(this.dataType.getImageClass(), width, height, this.numBands);
            }
        }
        throw new IllegalArgumentException("Type not yet supported");
    }

    public T[] createArray(int length) {
        switch (this.family) {
            case SINGLE_BAND: {
                return (ImageBase[])Array.newInstance(this.dataType.getImageClass(), length);
            }
            case MULTI_SPECTRAL: {
                return new MultiSpectral[length];
            }
        }
        throw new IllegalArgumentException("Type not yet supported");
    }

    public int getNumBands() {
        return this.numBands;
    }

    public Family getFamily() {
        return this.family;
    }

    public static enum Family {
        SINGLE_BAND,
        MULTI_SPECTRAL,
        INTERLEAVED;

    }
}

