/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageFloat;
import boofcv.struct.image.ImageTypeInfo;

public class ImageFloat64
extends ImageFloat<ImageFloat64> {
    public double[] data;

    public ImageFloat64(int width, int height) {
        super(width, height);
    }

    public ImageFloat64() {
    }

    public double get(int x, int y) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds: ( " + x + " , " + y + " )");
        }
        return this.unsafe_get(x, y);
    }

    public double unsafe_get(int x, int y) {
        return this.data[this.getIndex(x, y)];
    }

    public void set(int x, int y, double value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds: " + x + " " + y);
        }
        this.unsafe_set(x, y, value);
    }

    public void unsafe_set(int x, int y, double value) {
        this.data[this.getIndex((int)x, (int)y)] = value;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (double[])data;
    }

    @Override
    public ImageFloat64 _createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new ImageFloat64();
        }
        return new ImageFloat64(imgWidth, imgHeight);
    }

    @Override
    public ImageTypeInfo<ImageFloat64> getTypeInfo() {
        return ImageTypeInfo.F64;
    }
}

