/*
 * Decompiled with CFR 0.152.
 */
package boofcv.testing;

import boofcv.core.image.FactoryGImageSingleBand;
import boofcv.core.image.GImageSingleBand;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageInterleavedInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageTypeInfo;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import sun.awt.image.ByteInterleavedRaster;

public class BoofTesting {
    public static <T> T convertToGenericType(Class<?> type) {
        if (type == ImageSInt8.class || type == ImageUInt8.class) {
            return (T)ImageInt8.class;
        }
        if (type == ImageSInt16.class || type == ImageUInt16.class) {
            return (T)ImageInt16.class;
        }
        return (T)type;
    }

    public static ImageTypeInfo convertToGenericType(ImageTypeInfo<?> type) {
        if (type.isInteger()) {
            if (type.getNumBits() == 8) {
                return ImageTypeInfo.I8;
            }
            if (type.getNumBits() == 16) {
                return ImageTypeInfo.I16;
            }
        }
        return type;
    }

    public static <T> T convertGenericToSpecificType(Class<?> type) {
        if (type == ImageInt8.class) {
            return (T)ImageUInt8.class;
        }
        if (type == ImageInt16.class) {
            return (T)ImageSInt16.class;
        }
        return (T)type;
    }

    public static <T extends ImageSingleBand> T createSubImageOf(T input) {
        ImageBase ret = (ImageSingleBand)input._createNew(input.width + 10, input.height + 12);
        ret = ((ImageSingleBand)ret).subimage(5, 7, input.width + 5, input.height + 7);
        ((ImageSingleBand)ret).setTo(input);
        return (T)ret;
    }

    public static void checkImageDimensionValidation(Object testClass, int numFunctions) {
        Method[] methods;
        int count = 0;
        for (Method m : methods = testClass.getClass().getMethods()) {
            if (!BoofTesting.areAllInputsImages(m)) continue;
            Class<?>[] params = m.getParameterTypes();
            Object[] inputs = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                inputs[i] = GeneralizedImageOps.createSingleBand(params[i], 10, 20);
            }
            try {
                m.invoke(testClass, inputs);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (int target = 0; target < params.length; ++target) {
                for (int i = 0; i < params.length; ++i) {
                    inputs[i] = i != target ? GeneralizedImageOps.createSingleBand(params[i], 10, 20) : GeneralizedImageOps.createSingleBand(params[i], 11, 22);
                }
                try {
                    m.invoke(testClass, inputs);
                    throw new RuntimeException("Expected an exception here");
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException().getClass() == IllegalArgumentException.class) continue;
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++count;
        }
        if (count != numFunctions) {
            throw new RuntimeException("Unexpected number of functions");
        }
    }

    private static boolean areAllInputsImages(Method m) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length == 0) {
            return false;
        }
        for (Class<?> p : params) {
            if (ImageSingleBand.class.isAssignableFrom(p)) continue;
            return false;
        }
        return true;
    }

    public static void checkSubImage(Object testClass, String function, boolean checkEquals, Object ... inputParam) {
        try {
            int i;
            ImageBase[] larger = new ImageBase[inputParam.length];
            ImageBase[] subImg = new ImageBase[inputParam.length];
            Class[] paramDesc = new Class[inputParam.length];
            Object[] inputModified = new Object[inputParam.length];
            for (int i2 = 0; i2 < inputParam.length; ++i2) {
                if (ImageBase.class.isAssignableFrom(inputParam[i2].getClass())) {
                    ImageBase img = (ImageBase)inputParam[i2];
                    larger[i2] = img._createNew(img.getWidth() + 10, img.getHeight() + 12);
                    subImg[i2] = larger[i2].subimage(5, 6, 5 + img.getWidth(), 6 + img.getHeight());
                    subImg[i2].setTo(img);
                }
                inputModified[i2] = inputParam[i2];
                paramDesc[i2] = inputParam[i2].getClass();
            }
            Method m = BoofTesting.findMethod(testClass.getClass(), function, paramDesc);
            m.invoke(testClass, inputModified);
            for (i = 0; i < inputModified.length; ++i) {
                if (subImg[i] == null) continue;
                inputModified[i] = subImg[i];
            }
            m.invoke(testClass, inputModified);
            if (checkEquals) {
                for (i = 0; i < inputParam.length; ++i) {
                    if (subImg[i] == null) continue;
                    BoofTesting.assertEquals((ImageBase)inputModified[i], subImg[i], 0.0);
                }
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method findMethod(Class<?> type, String name, Class<?> ... params) {
        Method[] methods = type.getMethods();
        ArrayList<Method> found = new ArrayList<Method>();
        for (Method m : methods) {
            int i;
            Class<?>[] a;
            if (m.getName().compareTo(name) != 0 || (a = m.getParameterTypes()).length != params.length) continue;
            boolean match = true;
            for (i = 0; i < a.length; ++i) {
                if (a[i] == params[i]) continue;
                match = false;
                break;
            }
            if (match) {
                return m;
            }
            match = true;
            for (i = 0; i < a.length; ++i) {
                if (params[i] == a[i] || a[i].isPrimitive() && (a[i] == Byte.TYPE && params[i] == Byte.class || a[i] == Short.TYPE && params[i] == Short.class || a[i] == Integer.TYPE && params[i] == Integer.class || a[i] == Long.TYPE && params[i] == Long.class || a[i] == Float.TYPE && params[i] == Float.class || a[i] == Double.TYPE && params[i] == Double.class) || a[i].isAssignableFrom(params[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            found.add(m);
        }
        if (found.size() == 1) {
            return (Method)found.get(0);
        }
        throw new RuntimeException("Couldn't find matching *public* function to " + name);
    }

    public static void callStaticMethod(Class<?> classType, String name, Object ... inputs) {
        Class[] params = new Class[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            params[i] = inputs[i].getClass();
        }
        Method m = BoofTesting.findMethod(classType, name, params);
        if (m == null) {
            for (int i = 0; i < inputs.length; ++i) {
                if (params[i] == Integer.class) {
                    params[i] = Integer.TYPE;
                    continue;
                }
                if (params[i] == Float.class) {
                    params[i] = Float.TYPE;
                    continue;
                }
                if (params[i] != Double.class) continue;
                params[i] = Double.TYPE;
            }
            m = BoofTesting.findMethod(classType, name, params);
        }
        if (m == null) {
            throw new IllegalArgumentException("Method not found");
        }
        try {
            m.invoke(null, inputs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static int findMethodThenCall(Object owner, String ownerMethod, Class target, String targetMethod) {
        int total = 0;
        Method[] list = target.getMethods();
        try {
            Method om = owner.getClass().getMethod(ownerMethod, Method.class);
            for (Method m : list) {
                if (!m.getName().equals(targetMethod)) continue;
                om.invoke(owner, m);
                ++total;
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return total;
    }

    public static void assertEquals(double[] a, double[] b, double tol) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs(a[i] - b[i]);
            if (!(diff > tol)) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(double[] a, float[] b, double tol) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs(a[i] - (double)b[i]);
            if (!(diff > tol)) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(double[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs((int)a[i] - b[i]);
            if (diff == 0.0) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(float[] a, float[] b, float tol) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs(a[i] - b[i]);
            if (!(diff > (double)tol)) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(ImageBase imgA, ImageBase imgB, double tol) {
        if (imgA instanceof ImageSingleBand) {
            GImageSingleBand a = FactoryGImageSingleBand.wrap((ImageSingleBand)imgA);
            GImageSingleBand b = FactoryGImageSingleBand.wrap((ImageSingleBand)imgB);
            for (int y = 0; y < imgA.height; ++y) {
                for (int x = 0; x < imgA.width; ++x) {
                    double valB;
                    double valA = a.get(x, y).doubleValue();
                    double difference = valA - (valB = b.get(x, y).doubleValue());
                    if (!(Math.abs(difference) > tol)) continue;
                    throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                }
            }
        } else if (imgA instanceof MultiSpectral) {
            MultiSpectral a = (MultiSpectral)imgA;
            MultiSpectral b = (MultiSpectral)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            for (int band = 0; band < a.getNumBands(); ++band) {
                BoofTesting.assertEquals(a.getBand(band), b.getBand(band), tol);
            }
        } else if (imgA instanceof ImageInterleaved) {
            ImageInterleavedInt8 a = (ImageInterleavedInt8)imgA;
            ImageInterleavedInt8 b = (ImageInterleavedInt8)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            int numBands = a.getNumBands();
            for (int y = 0; y < imgA.height; ++y) {
                for (int x = 0; x < imgA.width; ++x) {
                    for (int band = 0; band < numBands; ++band) {
                        int valB;
                        int valA = a.getBand(x, y, band);
                        double difference = valA - (valB = b.getBand(x, y, band));
                        if (!(Math.abs(difference) > tol)) continue;
                        throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                    }
                }
            }
        } else {
            throw new RuntimeException("Unknown image type");
        }
    }

    public static void assertEqualsInner(ImageBase imgA, ImageBase imgB, double tol, int borderX, int borderY, boolean relative) {
        if (imgA instanceof ImageSingleBand) {
            GImageSingleBand a = FactoryGImageSingleBand.wrap((ImageSingleBand)imgA);
            GImageSingleBand b = FactoryGImageSingleBand.wrap((ImageSingleBand)imgB);
            for (int y = borderY; y < imgA.height - borderY; ++y) {
                for (int x = borderX; x < imgA.width - borderX; ++x) {
                    double valA = a.get(x, y).doubleValue();
                    double valB = b.get(x, y).doubleValue();
                    double error = Math.abs(valA - valB);
                    if (relative) {
                        double denominator = Math.abs(valA) + Math.abs(valB);
                        if (denominator == 0.0) {
                            denominator = 1.0;
                        }
                        error /= denominator;
                    }
                    if (!(error > tol)) continue;
                    throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                }
            }
        } else if (imgA instanceof MultiSpectral) {
            MultiSpectral a = (MultiSpectral)imgA;
            MultiSpectral b = (MultiSpectral)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            for (int band = 0; band < a.getNumBands(); ++band) {
                BoofTesting.assertEqualsInner(a.getBand(band), b.getBand(band), tol, borderX, borderY, relative);
            }
        } else {
            throw new RuntimeException("Unknown image type");
        }
    }

    public static void assertEqualsRelative(ImageBase imgA, ImageBase imgB, double tolFrac) {
        if (imgA instanceof ImageSingleBand) {
            GImageSingleBand a = FactoryGImageSingleBand.wrap((ImageSingleBand)imgA);
            GImageSingleBand b = FactoryGImageSingleBand.wrap((ImageSingleBand)imgB);
            for (int y = 0; y < imgA.height; ++y) {
                for (int x = 0; x < imgA.width; ++x) {
                    double valA = a.get(x, y).doubleValue();
                    double valB = b.get(x, y).doubleValue();
                    double difference = valA - valB;
                    double max = Math.max(Math.abs(valA), Math.abs(valB));
                    if (max == 0.0) {
                        max = 1.0;
                    }
                    if (!(Math.abs(difference) / max > tolFrac)) continue;
                    throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                }
            }
        } else if (imgA instanceof MultiSpectral) {
            MultiSpectral a = (MultiSpectral)imgA;
            MultiSpectral b = (MultiSpectral)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            for (int band = 0; band < a.getNumBands(); ++band) {
                BoofTesting.assertEqualsRelative(a.getBand(band), b.getBand(band), tolFrac);
            }
        } else {
            throw new RuntimeException("Unknown image type");
        }
    }

    public static void assertEqualsBorder(ImageSingleBand imgA, ImageSingleBand imgB, double tol, int borderX, int borderY) {
        if (imgA.getWidth() != imgB.getWidth()) {
            throw new RuntimeException("Widths are not equals");
        }
        if (imgA.getHeight() != imgB.getHeight()) {
            throw new RuntimeException("Heights are not equals");
        }
        GImageSingleBand a = FactoryGImageSingleBand.wrap(imgA);
        GImageSingleBand b = FactoryGImageSingleBand.wrap(imgB);
        for (int y = 0; y < imgA.getHeight(); ++y) {
            int x;
            for (x = 0; x < borderX; ++x) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
            for (x = imgA.getWidth() - borderX; x < imgA.getWidth(); ++x) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
        }
        for (int x = borderX; x < imgA.getWidth() - borderX; ++x) {
            int y;
            for (y = 0; y < borderY; ++y) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
            for (y = imgA.getHeight() - borderY; y < imgA.getHeight(); ++y) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
        }
    }

    private static void compareValues(double tol, GImageSingleBand a, GImageSingleBand b, int x, int y) {
        double normalizer = Math.abs(a.get(x, y).doubleValue()) + Math.abs(b.get(x, y).doubleValue());
        if (normalizer < 1.0) {
            normalizer = 1.0;
        }
        if (Math.abs(a.get(x, y).doubleValue() - b.get(x, y).doubleValue()) / normalizer > tol) {
            throw new RuntimeException("values not equal at (" + x + " " + y + ") " + a.get(x, y) + "  " + b.get(x, y));
        }
    }

    public static void checkEquals(BufferedImage imgA, ImageBase imgB, double tol) {
        if (ImageUInt8.class == imgB.getClass()) {
            BoofTesting.checkEquals(imgA, (ImageUInt8)imgB);
        } else if (ImageFloat32.class == imgB.getClass()) {
            BoofTesting.checkEquals(imgA, (ImageFloat32)imgB, (float)tol);
        } else if (ImageInterleavedInt8.class == imgB.getClass()) {
            BoofTesting.checkEquals(imgA, (ImageInterleavedInt8)imgB);
        } else if (MultiSpectral.class == imgB.getClass()) {
            BoofTesting.checkEquals(imgA, (MultiSpectral)imgB, (float)tol);
        }
    }

    public static void checkEquals(BufferedImage imgA, ImageUInt8 imgB) {
        ByteInterleavedRaster raster;
        if (imgA.getRaster() instanceof ByteInterleavedRaster && imgA.getType() != 13 && (raster = (ByteInterleavedRaster)imgA.getRaster()).getNumBands() == 1) {
            int strideA = raster.getScanlineStride();
            int offsetA = raster.getDataOffset(0) - raster.getNumBands() + 1;
            for (int i = 0; i < imgA.getHeight(); ++i) {
                for (int j = 0; j < imgA.getWidth(); ++j) {
                    int valB = imgB.get(j, i);
                    int valA = raster.getDataStorage()[offsetA + i * strideA + j];
                    if (!imgB.getTypeInfo().isSigned()) {
                        valA &= 0xFF;
                    }
                    if (valA == valB) continue;
                    throw new RuntimeException("Images are not equal: " + valA + " " + valB);
                }
            }
            return;
        }
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                int rgb = imgA.getRGB(x, y);
                int gray = ((rgb >>> 16 & 0xFF) + (rgb >>> 8 & 0xFF) + (rgb & 0xFF)) / 3;
                int grayB = imgB.get(x, y);
                if (!imgB.getTypeInfo().isSigned()) {
                    gray &= 0xFF;
                }
                if (Math.abs(gray - grayB) == 0) continue;
                throw new RuntimeException("images are not equal: (" + x + " , " + y + ") A = " + gray + " B = " + grayB);
            }
        }
    }

    public static void checkEquals(BufferedImage imgA, ImageFloat32 imgB, float tol) {
        ByteInterleavedRaster raster;
        if (imgA.getRaster() instanceof ByteInterleavedRaster && imgA.getType() != 13 && (raster = (ByteInterleavedRaster)imgA.getRaster()).getNumBands() == 1) {
            int strideA = raster.getScanlineStride();
            int offsetA = raster.getDataOffset(0) - raster.getNumBands() + 1;
            for (int i = 0; i < imgA.getHeight(); ++i) {
                for (int j = 0; j < imgA.getWidth(); ++j) {
                    float valB = imgB.get(j, i);
                    int valA = raster.getDataStorage()[offsetA + i * strideA + j];
                    if (!(Math.abs((float)(valA &= 0xFF) - valB) > tol)) continue;
                    throw new RuntimeException("Images are not equal: A = " + valA + " B = " + valB);
                }
            }
            return;
        }
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                float grayB;
                int rgb = imgA.getRGB(x, y);
                float gray = (float)((rgb >>> 16 & 0xFF) + (rgb >>> 8 & 0xFF) + (rgb & 0xFF)) / 3.0f;
                if (!(Math.abs(gray - (grayB = imgB.get(x, y))) > tol)) continue;
                throw new RuntimeException("images are not equal: A = " + gray + " B = " + grayB);
            }
        }
    }

    public static void checkEquals(BufferedImage imgA, ImageInterleavedInt8 imgB) {
        ByteInterleavedRaster raster;
        if (imgA.getRaster() instanceof ByteInterleavedRaster && (raster = (ByteInterleavedRaster)imgA.getRaster()).getNumBands() == 1) {
            for (int i = 0; i < imgA.getHeight(); ++i) {
                for (int j = 0; j < imgA.getWidth(); ++j) {
                    int valB = imgB.getBand(j, i, 0);
                    byte valA = raster.getDataStorage()[i * imgA.getWidth() + j];
                    if (valA == valB) continue;
                    throw new RuntimeException("Images are not equal");
                }
            }
            return;
        }
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                int rgb = imgA.getRGB(x, y);
                int r = rgb >>> 16 & 0xFF;
                int g = rgb >>> 8 & 0xFF;
                int b = rgb & 0xFF;
                if (Math.abs(b - imgB.getBand(x, y, 0) & 0xFF) != 0) {
                    throw new RuntimeException("images are not equal: ");
                }
                if (Math.abs(g - imgB.getBand(x, y, 1) & 0xFF) != 0) {
                    throw new RuntimeException("images are not equal: ");
                }
                if (Math.abs(r - imgB.getBand(x, y, 2) & 0xFF) == 0) continue;
                throw new RuntimeException("images are not equal: ");
            }
        }
    }

    public static void checkEquals(BufferedImage imgA, MultiSpectral imgB, float tol) {
        GImageSingleBand band3;
        GImageSingleBand band2;
        GImageSingleBand band1;
        ByteInterleavedRaster raster;
        if (imgA.getRaster() instanceof ByteInterleavedRaster && imgA.getType() != 13 && (raster = (ByteInterleavedRaster)imgA.getRaster()).getNumBands() == 1) {
            GImageSingleBand band = FactoryGImageSingleBand.wrap(imgB.getBand(0));
            int strideA = raster.getScanlineStride();
            int offsetA = raster.getDataOffset(0) - raster.getPixelStride() + 1;
            for (int i = 0; i < imgA.getHeight(); ++i) {
                for (int j = 0; j < imgA.getWidth(); ++j) {
                    double valB = band.get(j, i).doubleValue();
                    int valA = raster.getDataStorage()[offsetA + i * strideA + j];
                    if (!(Math.abs((double)(valA &= 0xFF) - valB) > (double)tol)) continue;
                    throw new RuntimeException("Images are not equal: A = " + valA + " B = " + valB);
                }
            }
            return;
        }
        if (imgA.getType() == 5 || imgA.getType() == 4) {
            band1 = FactoryGImageSingleBand.wrap(imgB.getBand(2));
            band2 = FactoryGImageSingleBand.wrap(imgB.getBand(1));
            band3 = FactoryGImageSingleBand.wrap(imgB.getBand(0));
        } else if (imgA.getType() == 1 || imgA.getType() == 13) {
            band1 = FactoryGImageSingleBand.wrap(imgB.getBand(0));
            band2 = FactoryGImageSingleBand.wrap(imgB.getBand(1));
            band3 = FactoryGImageSingleBand.wrap(imgB.getBand(2));
        } else if (imgA.getType() == 6) {
            band1 = FactoryGImageSingleBand.wrap(imgB.getBand(3));
            band2 = FactoryGImageSingleBand.wrap(imgB.getBand(2));
            band3 = FactoryGImageSingleBand.wrap(imgB.getBand(1));
        } else if (imgA.getType() == 2) {
            band1 = FactoryGImageSingleBand.wrap(imgB.getBand(1));
            band2 = FactoryGImageSingleBand.wrap(imgB.getBand(2));
            band3 = FactoryGImageSingleBand.wrap(imgB.getBand(3));
        } else {
            throw new RuntimeException("Handle this case");
        }
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                int rgb = imgA.getRGB(x, y);
                int val1 = rgb >>> 16 & 0xFF;
                int val2 = rgb >>> 8 & 0xFF;
                int val3 = rgb & 0xFF;
                float mult1 = band1.get(x, y).floatValue();
                float mult2 = band2.get(x, y).floatValue();
                float mult3 = band3.get(x, y).floatValue();
                if (Math.abs((float)val1 - mult1) > tol) {
                    throw new RuntimeException("images are not equal: A = " + val1 + " B = " + mult1);
                }
                if (Math.abs((float)val2 - mult2) > tol) {
                    throw new RuntimeException("images are not equal: A = " + val2 + " B = " + mult2);
                }
                if (!(Math.abs((float)val3 - mult3) > tol)) continue;
                throw new RuntimeException("images are not equal: A = " + val3 + " B = " + mult3);
            }
        }
    }

    public static void checkBorderZero(ImageSingleBand outputImage, int border) {
        GImageSingleBand img = FactoryGImageSingleBand.wrap(outputImage);
        for (int y = 0; y < img.getHeight(); ++y) {
            if (y >= border && y < img.getHeight() - border) continue;
            for (int x = 0; x < img.getWidth(); ++x) {
                if (x >= border && x < img.getWidth() - border || img.get(x, y).intValue() == 0) continue;
                throw new RuntimeException("The border is not zero: " + x + " " + y);
            }
        }
    }

    public static void printDiff(ImageSingleBand imgA, ImageSingleBand imgB) {
        GImageSingleBand a = FactoryGImageSingleBand.wrap(imgA);
        GImageSingleBand b = FactoryGImageSingleBand.wrap(imgB);
        System.out.println("------- Difference -----------");
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                double diff = Math.abs(a.get(x, y).doubleValue() - b.get(x, y).doubleValue());
                System.out.printf("%2d ", (int)diff);
            }
            System.out.println();
        }
    }
}

