/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.EngineerMath;
import JSci.maths.NumericalConstants;
import JSci.maths.wavelet.FWTCoef;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.Signal;

public final class FWTPacketCoef
implements NumericalConstants,
Cloneable {
    protected double[][] coefs;
    protected boolean[] StandardChoice;
    static final double normalisation = 0.7071067811865475;

    public FWTPacketCoef() {
    }

    public FWTPacketCoef(double[][] dArray, boolean[] blArray) {
        this.coefs = dArray;
        this.StandardChoice = blArray;
        if (blArray.length != dArray.length - 1) {
            throw new IllegalArgumentException("boolean[].length must be exactly double[][].length -1: boolean[].length=" + blArray.length + " and double[][].length=" + dArray.length);
        }
    }

    public Object clone() {
        try {
            FWTPacketCoef fWTPacketCoef = (FWTPacketCoef)super.clone();
            if (this.coefs != null) {
                fWTPacketCoef.coefs = ArrayMath.copy(this.coefs);
            }
            if (this.StandardChoice != null) {
                fWTPacketCoef.StandardChoice = new boolean[this.StandardChoice.length];
                System.arraycopy(this.StandardChoice, 0, fWTPacketCoef.StandardChoice, 0, this.StandardChoice.length);
            }
            return fWTPacketCoef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int getJ() {
        return this.coefs.length;
    }

    public int dimension(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("This scale doesn't exist : " + n + ", " + this.coefs.length);
        }
        return this.coefs[n].length;
    }

    public double[][] getCoefs() {
        return this.coefs;
    }

    public double[] norm() {
        double[] dArray = new double[this.coefs.length];
        for (int i = 0; i < this.coefs.length; ++i) {
            dArray[i] = ArrayMath.norm(this.coefs[i]);
        }
        return dArray;
    }

    public double norm(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.norm(this.coefs[n]);
        return d;
    }

    private double[] sumSquares() {
        double[] dArray = new double[this.coefs.length];
        for (int i = 0; i < this.coefs.length; ++i) {
            dArray[i] = ArrayMath.sumSquares(this.coefs[i]);
        }
        return dArray;
    }

    public double sumSquares(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " must be between 0 et " + (this.coefs.length - 1));
        }
        double d = ArrayMath.sumSquares(this.coefs[n]);
        return d;
    }

    public double mass(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.mass(this.coefs[n]);
        return d;
    }

    private double[] variance() {
        double[] dArray = new double[this.coefs.length];
        for (int i = 0; i < this.coefs.length; ++i) {
            dArray[i] = ArrayMath.variance(this.coefs[i]);
        }
        return dArray;
    }

    public double variance(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.variance(this.coefs[n]);
        return d;
    }

    public double sumEnergies() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = this.sumSquares();
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public double entropy() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double d = this.sumEnergies();
        int n = 0;
        for (int i = 0; i < this.coefs.length; ++i) {
            n += this.coefs[i].length;
        }
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 0; i < this.coefs.length; ++i) {
            for (int j = 0; j < this.coefs[i].length; ++j) {
                dArray[n2] = this.coefs[i][j] * this.coefs[i][j] / d;
                ++n2;
            }
        }
        return EngineerMath.icf(dArray);
    }

    public double sumVariance() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = this.variance();
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public double energyRatio(int n) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        if (this.sumEnergies() == 0.0) {
            if (this.coefs.length != 0) {
                return 1 / this.coefs.length;
            }
            throw new IllegalArgumentException("No energy!");
        }
        return this.sumSquares(n) / this.sumEnergies();
    }

    public double varianceRatio(int n) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parament " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        if (this.sumVariance() == 0.0) {
            if (this.coefs.length != 0) {
                return 1 / this.coefs.length;
            }
            throw new IllegalArgumentException("No variance!");
        }
        return this.variance(n) / this.sumVariance();
    }

    public double icf() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[this.coefs.length - 1];
        for (int i = 0; i < this.coefs.length; ++i) {
            dArray[i] = this.energyRatio(i);
        }
        return EngineerMath.icf(dArray);
    }

    public double varianceICF() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[this.coefs.length - 1];
        for (int i = 0; i < this.coefs.length; ++i) {
            dArray[i] = this.varianceRatio(i);
        }
        return EngineerMath.icf(dArray);
    }

    public void setCoefs(double[][] dArray) {
        this.coefs = dArray;
    }

    public void setPacket(boolean[] blArray) {
        this.StandardChoice = blArray;
    }

    public void setCoefs(double[] dArray, int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        this.coefs[n] = dArray;
    }

    public void synthesize(Filter filter, double[] dArray) {
        double[] dArray2;
        double[] dArray3;
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No synthesis left to do: " + this.coefs.length);
        }
        if (this.StandardChoice[this.StandardChoice.length - 1]) {
            dArray3 = filter.lowpass(this.coefs[this.coefs.length - 1], dArray);
            dArray3 = ArrayMath.scalarMultiply(0.7071067811865475, dArray3);
            dArray2 = filter.highpass(this.coefs[this.coefs.length - 2], dArray);
        } else {
            dArray3 = filter.lowpass(this.coefs[this.coefs.length - 2], dArray);
            dArray3 = ArrayMath.scalarMultiply(0.7071067811865475, dArray3);
            dArray2 = filter.highpass(this.coefs[this.coefs.length - 1], dArray);
        }
        if (dArray3.length != dArray2.length) {
            throw new IllegalArgumentException("Synthesis is impossible : bad data/multiresolution? " + this.coefs[0].length + ", " + this.coefs[this.coefs.length - 1].length + ", " + dArray3.length + ", " + dArray2.length);
        }
        dArray3 = ArrayMath.add(dArray3, dArray2);
        double[][] dArrayArray = new double[this.coefs.length - 1][];
        for (int i = 0; i < this.coefs.length - 2; ++i) {
            dArrayArray[i] = this.coefs[i];
        }
        dArrayArray[this.coefs.length - 1] = dArray3;
        this.coefs = dArrayArray;
        boolean[] blArray = new boolean[dArrayArray.length - 1];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.StandardChoice[i];
        }
        this.StandardChoice = blArray;
    }

    public void synthesize(Filter filter, double[] dArray, int n) {
        if (n < 0 || n > this.coefs.length - 1) {
            throw new IllegalArgumentException("The integer parameter " + n + " must be between 0 and " + (this.coefs.length - 1));
        }
        for (int i = 0; i < n; ++i) {
            this.synthesize(filter, dArray);
        }
    }

    public void synthesizeTout(Filter filter, double[] dArray) {
        this.synthesize(filter, dArray, this.coefs.length - 1);
    }

    public void synthesize(Filter filter) {
        double[] dArray;
        double[] dArray2;
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No synthesis left to do: " + this.coefs.length);
        }
        if (this.StandardChoice[this.StandardChoice.length - 1]) {
            dArray2 = filter.lowpass(this.coefs[this.coefs.length - 1]);
            dArray2 = ArrayMath.scalarMultiply(0.7071067811865475, dArray2);
            dArray = filter.highpass(this.coefs[this.coefs.length - 2]);
        } else {
            dArray2 = filter.lowpass(this.coefs[this.coefs.length - 2]);
            dArray2 = ArrayMath.scalarMultiply(0.7071067811865475, dArray2);
            dArray = filter.highpass(this.coefs[this.coefs.length - 1]);
        }
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException("Synthesis is impossible : bad data/multiresolution? " + this.coefs[0].length + ", " + this.coefs[this.coefs.length - 1].length + ", " + dArray2.length + ", " + dArray.length);
        }
        dArray2 = ArrayMath.add(dArray2, dArray);
        double[][] dArrayArray = new double[this.coefs.length - 1][];
        for (int i = 0; i < this.coefs.length - 2; ++i) {
            dArrayArray[i] = this.coefs[i];
        }
        dArrayArray[this.coefs.length - 1] = dArray2;
        this.coefs = dArrayArray;
        boolean[] blArray = new boolean[dArrayArray.length - 1];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.StandardChoice[i];
        }
        this.StandardChoice = blArray;
    }

    public void synthesize(Filter filter, int n) {
        if (n < 0 || n > this.coefs.length - 1) {
            throw new IllegalArgumentException("The integer parameter " + n + " must be between 0 and " + (this.coefs.length - 1));
        }
        for (int i = 0; i < n; ++i) {
            this.synthesize(filter);
        }
    }

    public void synthesizeAll(Filter filter) {
        this.synthesize(filter, this.coefs.length - 1);
    }

    public Signal rebuildSignal(Filter filter) {
        FWTCoef fWTCoef = new FWTCoef(this.coefs);
        fWTCoef.synthesizeAll(filter);
        return new Signal(fWTCoef.getCoefs()[0]);
    }

    public Signal rebuildSignal(Filter filter, double[] dArray) {
        FWTCoef fWTCoef = new FWTCoef(this.coefs);
        fWTCoef.synthesizeAll(filter, dArray);
        return new Signal(fWTCoef.getCoefs()[0]);
    }

    public void denoise(double d) {
        for (int i = 1; i < this.coefs.length; ++i) {
            this.coefs[i] = FWTPacketCoef.denoise(this.coefs[i], d);
        }
    }

    public void denoise(double d, int n) {
        this.coefs[n] = FWTPacketCoef.denoise(this.coefs[n], d);
    }

    public static double[] denoise(double[] dArray, double d) {
        if (d == 0.0) {
            return dArray;
        }
        double[] dArray2 = dArray;
        double d2 = ArrayMath.percentile(ArrayMath.abs(dArray2), 1.0 - d);
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(Math.abs(dArray2[i]) >= d2)) continue;
            dArray2[i] = 0.0;
        }
        return dArray2;
    }

    public void compress(double d) {
        for (int i = 0; i < this.coefs.length; ++i) {
            this.coefs[i] = FWTPacketCoef.compress(this.coefs[i], d);
        }
    }

    public void compress(double d, int n) {
        this.coefs[n] = FWTPacketCoef.compress(this.coefs[n], d);
    }

    public static double[] compress(double[] dArray, double d) {
        if (d == 0.0) {
            return dArray;
        }
        double[] dArray2 = dArray;
        double d2 = ArrayMath.percentile(ArrayMath.abs(dArray2), d);
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(Math.abs(dArray2[i]) <= d2)) continue;
            dArray2[i] = 0.0;
        }
        return dArray2;
    }

    public void denoiseHard(double d) {
        for (int i = 0; i < this.coefs.length; ++i) {
            this.coefs[i] = FWTPacketCoef.denoiseHard(this.coefs[i], d);
        }
    }

    public void denoiseHard(double d, int n) {
        this.coefs[n] = FWTPacketCoef.denoiseHard(this.coefs[n], d);
    }

    public static double[] denoiseHard(double[] dArray, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The cutoff value must be positive.");
        }
        double[] dArray2 = dArray;
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(Math.abs(dArray2[i]) >= d)) continue;
            dArray2[i] = 0.0;
        }
        return dArray2;
    }

    public void compressHard(double d) {
        for (int i = 0; i < this.coefs.length; ++i) {
            this.coefs[i] = FWTPacketCoef.compressHard(this.coefs[i], d);
        }
    }

    public void compressHard(double d, int n) {
        this.coefs[n] = FWTPacketCoef.compressHard(this.coefs[n], d);
    }

    public static double[] compressHard(double[] dArray, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The cutoff value must be positive.");
        }
        double[] dArray2 = dArray;
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(Math.abs(dArray2[i]) <= d)) continue;
            dArray2[i] = 0.0;
        }
        return dArray2;
    }
}

