/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.CategoryGraph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.swing.JBarGraph;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class JStackedBarGraph
extends JBarGraph {
    public JStackedBarGraph(CategoryGraph2DModel categoryGraph2DModel) {
        super(categoryGraph2DModel);
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        this.minY = 0.0f;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.model.firstSeries();
        for (int i = 0; i < this.model.seriesLength(); ++i) {
            float f = this.model.getValue(i);
            while (this.model.nextSeries()) {
                f += this.model.getValue(i);
            }
            this.minY = Math.min(f, this.minY);
            this.maxY = Math.max(f, this.maxY);
            this.model.firstSeries();
        }
        if (this.minY == this.maxY) {
            this.minY -= 0.5f;
            this.maxY += 0.5f;
        }
        this.setNumbering(this.numbering);
    }

    protected void drawBars(Graphics graphics) {
        for (int i = 0; i < this.model.seriesLength(); ++i) {
            int n;
            this.model.firstSeries();
            int n2 = n = this.drawStackedBar(graphics, i, this.model.getValue(i), this.barColor[0], 0);
            int n3 = 1;
            while (this.model.nextSeries()) {
                n = this.drawStackedBar(graphics, i, this.model.getValue(i), this.barColor[n3], -n2);
                n2 += n;
                ++n3;
            }
        }
    }

    private int drawStackedBar(Graphics graphics, int n, float f, Color color, int n2) {
        Point point = f < 0.0f ? this.dataToScreen(n, 0.0f) : this.dataToScreen(n, f);
        graphics.setColor(color);
        int n3 = Math.abs(point.y - this.origin.y);
        graphics.fillRect(point.x + 0, point.y + n2, this.barWidth, n3);
        graphics.setColor(Color.black);
        graphics.drawRect(point.x + 0, point.y + n2, this.barWidth, n3);
        return n3;
    }
}

