/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.core.annotation.DeprecatedClass;
import adams.data.conversion.AbstractSpreadSheetConversion;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.RowIdentifier;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.statistics.StatUtils;
import adams.flow.transformer.SpreadSheetAggregate;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@Deprecated
@DeprecatedClass(useInstead={SpreadSheetAggregate.class})
public class AggregateSpreadSheet
extends AbstractSpreadSheetConversion {
    private static final long serialVersionUID = -1789320708357341617L;
    protected SpreadSheetColumnRange m_KeyColumns;
    protected SpreadSheetColumnRange m_AggregateColumns;
    protected SpreadSheetAggregate.Aggregate[] m_Aggregates;

    public String globalInfo() {
        return "Aggregates rows (min, max, avg, etc) in a spreadsheet using key columns.\nAll numeric columns in the specified aggregrate range (excluding the key columns) get aggregated. For each of the specified aggregates a new column is generated.\n\nDEPRECATED:\nUse " + SpreadSheetAggregate.class.getName() + " instead!";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key-columns", "keyColumns", (Object)new SpreadSheetColumnRange("first"));
        this.m_OptionManager.add("aggregate-columns", "aggregateColumns", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("aggregate", "aggregates", (Object)new SpreadSheetAggregate.Aggregate[]{SpreadSheetAggregate.Aggregate.SUM});
    }

    public void setKeyColumns(SpreadSheetColumnRange value) {
        this.m_KeyColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getKeyColumns() {
        return this.m_KeyColumns;
    }

    public String keyColumnsTipText() {
        return "The columns to use as keys for identifying rows in the spreadsheets; " + this.m_KeyColumns.getExample();
    }

    public void setAggregateColumns(SpreadSheetColumnRange value) {
        this.m_AggregateColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getAggregateColumns() {
        return this.m_AggregateColumns;
    }

    public String aggregateColumnsTipText() {
        return "The columns to aggregate (only numeric ones will be used); " + this.m_KeyColumns.getExample();
    }

    public void setAggregates(SpreadSheetAggregate.Aggregate[] value) {
        this.m_Aggregates = value;
        this.reset();
    }

    public SpreadSheetAggregate.Aggregate[] getAggregates() {
        return this.m_Aggregates;
    }

    public String aggregatesTipText() {
        return "The aggregates to calculate and introduce as columns.";
    }

    protected HashMap<SpreadSheetAggregate.Aggregate, Number> computeAggregates(SpreadSheet input, List<Integer> subset, int index) {
        HashMap<SpreadSheetAggregate.Aggregate, Number> result = new HashMap<SpreadSheetAggregate.Aggregate, Number>();
        for (SpreadSheetAggregate.Aggregate agg : this.m_Aggregates) {
            result.put(agg, Double.NaN);
        }
        TDoubleArrayList list = new TDoubleArrayList();
        for (int i = 0; i < subset.size(); ++i) {
            Cell cell = input.getCell(subset.get(i).intValue(), index);
            if (cell == null || !cell.isNumeric()) continue;
            list.add(cell.toDouble().doubleValue());
        }
        double[] values = list.toArray();
        if (values.length > 0) {
            block13: for (SpreadSheetAggregate.Aggregate agg : this.m_Aggregates) {
                switch (agg) {
                    case COUNT: {
                        result.put(agg, values.length);
                        continue block13;
                    }
                    case SUM: {
                        result.put(agg, StatUtils.sum((double[])values));
                        continue block13;
                    }
                    case MIN: {
                        result.put(agg, StatUtils.min((double[])values));
                        continue block13;
                    }
                    case MAX: {
                        result.put(agg, StatUtils.max((double[])values));
                        continue block13;
                    }
                    case AVERAGE: {
                        result.put(agg, StatUtils.mean((double[])values));
                        continue block13;
                    }
                    case MEDIAN: {
                        result.put(agg, StatUtils.median((double[])values));
                        continue block13;
                    }
                    case STDEV: {
                        result.put(agg, StatUtils.stddev((double[])values, (boolean)true));
                        continue block13;
                    }
                    case STDEVP: {
                        result.put(agg, StatUtils.stddev((double[])values, (boolean)false));
                        continue block13;
                    }
                    case INTERQUARTILE: {
                        result.put(agg, StatUtils.iqr((double[])values));
                        continue block13;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled aggregate: " + (Object)((Object)agg));
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        this.m_KeyColumns.setSpreadSheet(input);
        int[] keys = this.m_KeyColumns.getIntIndices();
        if (keys.length == 0) {
            throw new IllegalStateException("No key columns defined!");
        }
        RowIdentifier rows = new RowIdentifier((Range)this.m_KeyColumns);
        this.m_AggregateColumns.setSpreadSheet(input);
        int[] agg = this.m_AggregateColumns.getIntIndices();
        TIntHashSet numeric = new TIntHashSet();
        for (int index : agg) {
            if (this.m_KeyColumns.isInRange(index) || !input.isNumeric(index, true)) continue;
            numeric.add(index);
        }
        agg = numeric.toArray();
        Arrays.sort(agg);
        rows.identify(input);
        SpreadSheet result = input.newInstance();
        result.setDataRowClass(input.getDataRowClass());
        HeaderRow row = result.getHeaderRow();
        for (int index : keys) {
            row.addCell("" + index).setContent(input.getHeaderRow().getCell(index).getContent());
        }
        for (int index : agg) {
            for (SpreadSheetAggregate.Aggregate a : this.m_Aggregates) {
                row.addCell("" + index + "-" + (Object)((Object)a)).setContent(input.getHeaderRow().getCell(index).getContent() + "-" + (Object)((Object)a));
            }
        }
        for (String key : rows.getKeys()) {
            DataRow rowNew = result.addRow();
            List subset = rows.getRows(key);
            for (int index : keys) {
                rowNew.addCell("" + index).setContent(input.getRow(((Integer)subset.get(0)).intValue()).getCell(index).getContent());
            }
            for (int index : agg) {
                HashMap<SpreadSheetAggregate.Aggregate, Number> aggs = this.computeAggregates(input, subset, index);
                for (SpreadSheetAggregate.Aggregate a : this.m_Aggregates) {
                    if (aggs.get(agg) instanceof Integer) {
                        rowNew.addCell("" + index + "-" + (Object)((Object)a)).setContent((Integer)aggs.get((Object)a));
                        continue;
                    }
                    if (aggs.get(agg) instanceof Long) {
                        rowNew.addCell("" + index + "-" + (Object)((Object)a)).setContent((Long)aggs.get((Object)a));
                        continue;
                    }
                    rowNew.addCell("" + index + "-" + (Object)((Object)a)).setContent(Double.valueOf(aggs.get((Object)a).doubleValue()));
                }
            }
        }
        return result;
    }
}

