/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.AbstractContainer;
import java.util.Iterator;

public class ContainerToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -2460280741242049565L;

    public String globalInfo() {
        return "Converts any container into a SpreadSheet object.";
    }

    public Class accepts() {
        return AbstractContainer.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        SpreadSheet result = new SpreadSheet();
        AbstractContainer cont = (AbstractContainer)this.getInput();
        HeaderRow row = result.getHeaderRow();
        row.addCell("key").setContent("Key");
        row.addCell("value").setContent("Value");
        Iterator names = cont.stored();
        while (names.hasNext()) {
            String name = (String)names.next();
            row = result.addRow("" + result.getRowCount());
            Object value = cont.getValue(name);
            row.addCell("key").setContent(name);
            if (value != null && value.getClass().isArray()) {
                value = Utils.arrayToString((Object)value);
            }
            row.addCell("value").setContent("" + value);
        }
        return result;
    }
}

