/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractSpreadSheetColumnConverter;
import adams.data.spreadsheet.Cell;

public class SpreadSheetStringColumnToBoolean
extends AbstractSpreadSheetColumnConverter {
    private static final long serialVersionUID = 2390017930652080091L;
    protected String m_ValueTrue;
    protected boolean m_CaseInsensitive;

    public String globalInfo() {
        return "Converts the specified spreadsheet column from string to boolean.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("value-true", "valueTrue", (Object)"true");
        this.m_OptionManager.add("case-insensitive", "caseInsensitive", (Object)false);
    }

    @Override
    public String columnTipText() {
        return "The column to convert to boolean; " + this.m_Column.getExample();
    }

    public void setValueTrue(String value) {
        this.m_ValueTrue = value;
        this.reset();
    }

    public String getValueTrue() {
        return this.m_ValueTrue;
    }

    public String valueTrueTipText() {
        return "The value representing 'true'.";
    }

    public void setCaseInsensitive(boolean value) {
        this.m_CaseInsensitive = value;
        this.reset();
    }

    public boolean getCaseInsensitive() {
        return this.m_CaseInsensitive;
    }

    public String caseInsensitiveTipText() {
        return "If enabled, strings are matched case-sensitive.";
    }

    @Override
    protected void convert(Cell cellOld, Cell cellNew) throws Exception {
        String content = cellOld.getContent().trim();
        if (this.m_CaseInsensitive) {
            cellNew.setContent(Boolean.valueOf(content.equals(this.m_ValueTrue)));
        } else {
            cellNew.setContent(Boolean.valueOf(content.equalsIgnoreCase(this.m_ValueTrue)));
        }
    }
}

