/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;

public class SpreadSheetToStringMatrix
extends AbstractConversion {
    private static final long serialVersionUID = 4117708470154504868L;

    public String globalInfo() {
        return "Turns a spreadsheet into a string matrix.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return String[][].class;
    }

    protected Object doConvert() throws Exception {
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        String[][] result = new String[sheet.getRowCount()][sheet.getColumnCount()];
        for (int n = 0; n < sheet.getRowCount(); ++n) {
            DataRow row = sheet.getRow(n);
            for (int i = 0; i < sheet.getColumnCount(); ++i) {
                result[n][i] = !row.hasCell(i) ? "" : row.getCell(i).getContent();
            }
        }
        return result;
    }
}

