/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.SpreadSheet;
import java.util.HashSet;

public class SpreadSheetUniqueColumnNames
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = 4937434241898052790L;

    public String globalInfo() {
        return "Ensures that column names are unique. Appends '-X' to the name, with X being a number.";
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = this.m_NoCopy ? input : input.getClone();
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < result.getColumnCount(); ++i) {
            String name;
            String base = result.getHeaderRow().getCell(i).getContent();
            if (names.contains(base)) {
                int count = 1;
                while (names.contains(name = base + "-" + ++count)) {
                }
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("column #" + (i + 1) + ": '" + base + "' -> '" + name + "'");
                }
                result.getHeaderRow().getCell(i).setContentAsString(name);
            } else {
                name = base;
            }
            names.add(name);
        }
        return result;
    }
}

