/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateTime;
import adams.core.QuickInfoHelper;
import adams.core.Time;
import adams.core.option.OptionHandler;
import adams.data.conversion.Conversion;
import adams.data.conversion.ObjectToObject;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.Date;
import java.util.Iterator;

public class SpreadSheetConvertHeaderCells
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = -4633161214275622241L;
    protected boolean m_SkipMissing;
    protected String m_MissingReplacementValue;
    protected Cell.ContentType m_MissingReplacementType;
    protected Conversion m_Conversion;
    protected Cell m_Cell;

    public String globalInfo() {
        return "Converts the header cells of a spreadsheet with a conversion scheme.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("skip-missing", "skipMissing", (Object)true);
        this.m_OptionManager.add("missing-replacement-value", "missingReplacementValue", (Object)"");
        this.m_OptionManager.add("missing-replacement-type", "missingReplacementType", (Object)Cell.ContentType.STRING);
        this.m_OptionManager.add("conversion", "conversion", (Object)new ObjectToObject());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"conversion", (Object)this.m_Conversion, (String)"conversion: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"skipMissing", (boolean)this.m_SkipMissing, (String)"skip missing", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        return result;
    }

    public void setSkipMissing(boolean value) {
        this.m_SkipMissing = value;
        this.reset();
    }

    public boolean getSkipMissing() {
        return this.m_SkipMissing;
    }

    public String skipMissingTipText() {
        return "If enabled, missing cells are skipped.";
    }

    public void setMissingReplacementValue(String value) {
        this.m_MissingReplacementValue = value;
        this.reset();
    }

    public String getMissingReplacementValue() {
        return this.m_MissingReplacementValue;
    }

    public String missingReplacementValueTipText() {
        return "The string representation of the value to use for replacing missing values.";
    }

    public void setMissingReplacementType(Cell.ContentType value) {
        this.m_MissingReplacementType = value;
        this.reset();
    }

    public Cell.ContentType getMissingReplacementType() {
        return this.m_MissingReplacementType;
    }

    public String missingReplacementTypeTipText() {
        return "The data type to use for the replacement value for missing values.";
    }

    public void setConversion(Conversion value) {
        this.m_Conversion = value;
        this.reset();
    }

    public Conversion getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion to apply to the header cells.";
    }

    protected String convertCell(Cell cell, SpreadSheet sheet) {
        String result = null;
        Object input = null;
        Object output = null;
        if (this.m_Cell == null) {
            this.m_Cell = sheet.newCell();
        }
        if (cell.isMissing()) {
            if (this.m_SkipMissing) {
                return null;
            }
            input = this.m_Cell.parseContent(this.m_MissingReplacementValue, this.m_MissingReplacementType);
        }
        Class classIn = this.m_Conversion.accepts();
        Class classOut = this.m_Conversion.generates();
        if (input == null) {
            if (classIn == Double.class) {
                input = cell.toDouble();
            } else if (classIn == Integer.class) {
                input = cell.toLong().intValue();
            } else if (classIn == Long.class) {
                input = cell.toLong();
            } else if (classIn == Date.class) {
                input = cell.toDate();
            } else if (classIn == DateTime.class) {
                input = cell.toDateTime();
            } else if (classIn == Time.class) {
                input = cell.toTime();
            } else if (classIn == String.class) {
                input = cell.getContent();
            } else {
                result = "Don't know how to get cell value for conversion input type: " + classIn.getName();
            }
        }
        if (result == null) {
            this.m_Conversion.setInput(input);
            result = this.m_Conversion.convert();
        }
        if (result == null) {
            output = this.m_Conversion.getOutput();
            this.m_Conversion.cleanUp();
            if (classOut == Double.class) {
                cell.setContent((Double)output);
            } else if (classOut == Integer.class) {
                cell.setContent((Integer)output);
            } else if (classOut == Long.class) {
                cell.setContent((Long)output);
            } else if (classOut == Date.class) {
                cell.setContent((Date)output);
            } else if (classOut == DateTime.class) {
                cell.setContent((DateTime)output);
            } else if (classOut == Time.class) {
                cell.setContent((Time)output);
            } else if (classOut == String.class) {
                cell.setContentAsString((String)output);
            } else {
                result = "Don't know how to set cell value for conversion output type: " + classOut.getName();
            }
        }
        return result;
    }

    protected String doExecute() {
        Cell cell;
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        Iterator i$ = sheetNew.getHeaderRow().cells().iterator();
        while (i$.hasNext() && (result = this.convertCell(cell = (Cell)i$.next(), sheetNew)) == null && !this.m_Stopped) {
        }
        if (result == null && !this.m_Stopped) {
            this.m_OutputToken = new Token((Object)sheetNew);
        }
        return result;
    }

    public void stopExecution() {
        super.stopExecution();
        this.m_Conversion.stopExecution();
    }
}

